/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;

public final class PopupMenuUtils {
    private PopupMenuUtils() {
    }

    public static boolean isAtLeastOneChildComponentVisible(Container component) {
        for (Component comp : component.getComponents()) {
            if (!comp.isVisible()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAtLeastOneChildComponentVisible(JMenu menu) {
        return PopupMenuUtils.isAtLeastOneChildComponentVisible(menu.getPopupMenu());
    }

    public static boolean isExtensionPopupMenuItem(Component component) {
        return component instanceof ExtensionPopupMenuItem;
    }

    public static boolean isExtensionPopupMenu(Component component) {
        return component instanceof ExtensionPopupMenu;
    }

    public static boolean isExtensionPopupMenuComponent(Component component) {
        return component instanceof ExtensionPopupMenuComponent;
    }

    public static boolean isExtensionPopupMenuComponent(MenuElement menuElement) {
        return menuElement instanceof ExtensionPopupMenuComponent;
    }

    public static boolean isPopupMenuSeparator(Component component) {
        return component instanceof JPopupMenu.Separator;
    }

    public static void removeAllSeparators(JPopupMenu popupMenu) {
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            if (!PopupMenuUtils.isPopupMenuSeparator(popupMenu.getComponent(i))) continue;
            popupMenu.remove(i);
            --i;
        }
    }

    public static void removeAllSeparators(JMenu menu) {
        PopupMenuUtils.removeAllSeparators(menu.getPopupMenu());
    }

    public static void removeConsecutiveSeparators(JPopupMenu popupMenu) {
        for (int i = 1; i < popupMenu.getComponentCount(); ++i) {
            if (!PopupMenuUtils.isPopupMenuSeparator(popupMenu.getComponent(i)) || !PopupMenuUtils.isPopupMenuSeparator(popupMenu.getComponent(i - 1))) continue;
            popupMenu.remove(i);
            --i;
        }
    }

    public static void removeConsecutiveSeparators(JMenu menu) {
        PopupMenuUtils.removeConsecutiveSeparators(menu.getPopupMenu());
    }

    public static void removeTopSeparators(JPopupMenu popupMenu) {
        while (popupMenu.getComponentCount() > 0 && PopupMenuUtils.isPopupMenuSeparator(popupMenu.getComponent(0))) {
            popupMenu.remove(0);
        }
    }

    public static void removeTopSeparators(JMenu menu) {
        PopupMenuUtils.removeTopSeparators(menu.getPopupMenu());
    }

    public static void removeBottomSeparators(JPopupMenu popupMenu) {
        for (int indexLastComponent = popupMenu.getComponentCount() - 1; indexLastComponent >= 0 && PopupMenuUtils.isPopupMenuSeparator(popupMenu.getComponent(indexLastComponent)); --indexLastComponent) {
            popupMenu.remove(indexLastComponent);
        }
    }

    public static void removeBottomSeparators(JMenu menu) {
        PopupMenuUtils.removeBottomSeparators(menu.getPopupMenu());
    }

    public static void removeTopAndBottomSeparators(JPopupMenu popupMenu) {
        if (popupMenu.getComponentCount() == 0) {
            return;
        }
        PopupMenuUtils.removeTopSeparators(popupMenu);
        PopupMenuUtils.removeBottomSeparators(popupMenu);
    }

    public static void removeTopAndBottomSeparators(JMenu menu) {
        PopupMenuUtils.removeTopAndBottomSeparators(menu.getPopupMenu());
    }

    public static boolean addSeparatorIfNeeded(JPopupMenu popupMenu) {
        int menuComponentCount = popupMenu.getComponentCount();
        if (menuComponentCount == 0) {
            return false;
        }
        Component lastMenuComponent = popupMenu.getComponent(menuComponentCount - 1);
        if (PopupMenuUtils.isPopupMenuSeparator(lastMenuComponent)) {
            return false;
        }
        popupMenu.addSeparator();
        return true;
    }

    public static boolean addSeparatorIfNeeded(JMenu menu) {
        return PopupMenuUtils.addSeparatorIfNeeded(menu.getPopupMenu());
    }

    public static boolean insertSeparatorIfNeeded(JPopupMenu popupMenu, int position) {
        int menuComponentCount = popupMenu.getComponentCount();
        if (menuComponentCount == 0 || position <= 0 || position > menuComponentCount) {
            return false;
        }
        Component currentComponent = popupMenu.getComponent(position);
        if (PopupMenuUtils.isPopupMenuSeparator(currentComponent)) {
            return false;
        }
        Component previousComponent = popupMenu.getComponent(position - 1);
        if (PopupMenuUtils.isPopupMenuSeparator(previousComponent)) {
            return false;
        }
        popupMenu.insert(new JPopupMenu.Separator(), position);
        return true;
    }

    public static boolean insertSeparatorIfNeeded(JMenu menu, int position) {
        return PopupMenuUtils.insertSeparatorIfNeeded(menu.getPopupMenu(), position);
    }

    public static PopupMenuInvokerWrapper getPopupMenuInvokerWrapper(Component component) {
        return new ComponentPopupMenuInvoker(component);
    }

    public static PopupMenuInvokerWrapper getPopupMenuInvokerWrapper(MessageContainer<?> messageContainer) {
        return new MessageContainerPopupMenuInvoker(messageContainer);
    }

    public static class ComponentPopupMenuInvoker
    extends PopupMenuInvokerWrapper {
        public ComponentPopupMenuInvoker(Component component) {
            super(component);
        }

        @Override
        public boolean isEnable(ExtensionPopupMenuComponent menuComponent) {
            return menuComponent.isEnableForComponent(this.getComponent());
        }
    }

    public static class MessageContainerPopupMenuInvoker
    extends PopupMenuInvokerWrapper {
        private final MessageContainer<?> messageContainer;

        public MessageContainerPopupMenuInvoker(MessageContainer<?> messageContainer) {
            super(messageContainer.getComponent());
            this.messageContainer = messageContainer;
        }

        @Override
        public boolean isEnable(ExtensionPopupMenuComponent menuComponent) {
            return menuComponent.isEnableForMessageContainer(this.messageContainer);
        }
    }

    public static abstract class PopupMenuInvokerWrapper {
        private final Component component;

        public PopupMenuInvokerWrapper(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("Parameter component must not be null.");
            }
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }

        public abstract boolean isEnable(ExtensionPopupMenuComponent var1);
    }
}

