# SPDX-License-Identifier: Apache-2.0
# Copyright (C) 2019-2021 Xilinx, Inc. All rights reserved.

# --------------------
# aiebu-config.cmake
# --------------------
#
# AIEBU cmake module.
# This module sets the following variables in your project::
#
#   AIEBU_FOUND              - true if AIEBU and all required components found on the system
#   AIEBU_VERSION            - VERSION of this package in x.y.z format
#   AIEBU_CMAKE_DIR          - Directory where this cmake module was found
#   AIEBU_INCLUDE_DIRS       - Directory where AIEBU headers are located.
#   AIEBU_LINK_DIRS          - Directory where AIEBU link libraries are located.
#   AIEBU_CORE_LIBRARIES     - libraries to link against.

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was aiebu.fp.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(AIEBU_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(AIEBU_LINK_DIRS "${PACKAGE_PREFIX_DIR}/lib")

set(AIEBU_VERSION 1.0.0)

get_filename_component(AIEBU_CMAKE_DIR "${CMAKE_CURRENT_LIST_DIR}" ABSOLUTE)

set(AIEBU_CORE_LIBRARIES AIEBU::aiebu AIEBU::aiebu_static)

set(AIEBU_FOUND True)

message(STATUS "Found AIEBU: ${AIEBU_CMAKE_DIR} (found version \"${AIEBU_VERSION}\")")

include("${CMAKE_CURRENT_LIST_DIR}/aiebu-targets.cmake")
