"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentNames = getComponentNames;
const utils_1 = require("./utils");
function getComponentNames(ts, program, fileName) {
    const names = (0, utils_1.getVariableType)(ts, program, fileName, '__VLS_components')
        ?.type
        .getProperties()
        .map(c => c.name)
        .filter(entry => !entry.includes('$') && !entry.startsWith('_'))
        ?? [];
    names.push((0, utils_1.getSelfComponentName)(fileName));
    return names;
}
//# sourceMappingURL=getComponentNames.js.map