/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre12Compat;
import org.apache.tomcat.util.compat.Jre16Compat;
import org.apache.tomcat.util.compat.Jre19Compat;
import org.apache.tomcat.util.compat.Jre20Compat;
import org.apache.tomcat.util.compat.Jre21Compat;
import org.apache.tomcat.util.compat.Jre22Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final Log log = LogFactory.getLog(JreCompat.class);
    private static final StringManager sm = StringManager.getManager(JreCompat.class);
    private static final JreCompat instance;
    private static final boolean graalAvailable;
    private static final boolean jre12Available;
    private static final boolean jre16Available;
    private static final boolean jre19Available;
    private static final boolean jre20Available;
    private static final boolean jre21Available;
    private static final boolean jre22Available;
    protected static final String USE_CANON_CACHES_CMD_ARG = "-Dsun.io.useCanonCaches=";
    protected static volatile Boolean canonCachesDisabled;
    protected static final Object canonCachesDisabledLock;
    protected static volatile Optional<Field> useCanonCachesField;
    protected static final Object useCanonCachesFieldLock;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isGraalAvailable() {
        return graalAvailable;
    }

    public static boolean isJre12Available() {
        return jre12Available;
    }

    public static boolean isJre16Available() {
        return jre16Available;
    }

    public static boolean isJre19Available() {
        return jre19Available;
    }

    public static boolean isJre20Available() {
        return jre20Available;
    }

    public static boolean isJre21Available() {
        return jre21Available;
    }

    public static boolean isJre22Available() {
        return jre22Available;
    }

    public SocketAddress getUnixDomainSocketAddress(String string) {
        return null;
    }

    public ServerSocketChannel openUnixDomainServerSocketChannel() {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noUnixDomainSocket"));
    }

    public SocketChannel openUnixDomainSocketChannel() {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noUnixDomainSocket"));
    }

    public Object getExecutor(Thread thread) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object object = null;
        Object object2 = null;
        for (String string : new String[]{"target", "runnable", "action"}) {
            try {
                Field field = thread.getClass().getDeclaredField(string);
                field.setAccessible(true);
                object2 = field.get(thread);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        if (object2 != null && object2.getClass().getCanonicalName() != null && (object2.getClass().getCanonicalName().equals("org.apache.tomcat.util.threads.ThreadPoolExecutor.Worker") || object2.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker"))) {
            Field field = object2.getClass().getDeclaredField("this$0");
            field.setAccessible(true);
            object = field.get(object2);
        }
        return object;
    }

    public Object createVirtualThreadBuilder(String string) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noVirtualThreads"));
    }

    public void threadBuilderStart(Object object, Runnable runnable) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noVirtualThreads"));
    }

    public <T> T callAs(Subject subject, final Callable<T> callable) throws CompletionException {
        try {
            return Subject.doAs(subject, new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return callable.call();
                }
            });
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanonCachesDisabled() {
        if (canonCachesDisabled != null) {
            return canonCachesDisabled;
        }
        Object object = canonCachesDisabledLock;
        synchronized (object) {
            if (canonCachesDisabled != null) {
                return canonCachesDisabled;
            }
            boolean bl = true;
            List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String string : list) {
                if (!string.startsWith(USE_CANON_CACHES_CMD_ARG)) continue;
                String string2 = string.substring(USE_CANON_CACHES_CMD_ARG.length());
                boolean bl2 = Boolean.valueOf(string2);
                if (bl2) {
                    canonCachesDisabled = Boolean.FALSE;
                    return false;
                }
                bl = false;
            }
            canonCachesDisabled = bl ? Boolean.FALSE : Boolean.TRUE;
            return canonCachesDisabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disableCanonCaches() {
        this.ensureUseCanonCachesFieldIsPopulated();
        if (useCanonCachesField.isEmpty()) {
            log.warn((Object)sm.getString("jreCompat.useCanonCaches.none"));
            return false;
        }
        try {
            useCanonCachesField.get().set(null, Boolean.FALSE);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            log.warn((Object)sm.getString("jreCompat.useCanonCaches.failed"), (Throwable)exception);
            return false;
        }
        Object object = canonCachesDisabledLock;
        synchronized (object) {
            canonCachesDisabled = Boolean.TRUE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureUseCanonCachesFieldIsPopulated() {
        if (useCanonCachesField != null) {
            return;
        }
        Object object = useCanonCachesFieldLock;
        synchronized (object) {
            if (useCanonCachesField != null) {
                return;
            }
            Field field = null;
            try {
                Class<?> clazz = Class.forName("java.io.FileSystem");
                field = clazz.getDeclaredField("useCanonCaches");
                field.setAccessible(true);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | InaccessibleObjectException exception) {
                field = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.init"), (Throwable)exception);
            }
            useCanonCachesField = field == null ? Optional.empty() : Optional.of(field);
        }
    }

    public void setNamedGroupsMethod(Object object, String[] stringArray) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noNamedGroups"));
    }

    static {
        canonCachesDisabledLock = new Object();
        useCanonCachesFieldLock = new Object();
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            bl = Boolean.TRUE.equals(clazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        boolean bl2 = graalAvailable = bl || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        if (Jre22Compat.isSupported()) {
            instance = new Jre22Compat();
            jre22Available = true;
            jre21Available = true;
            jre20Available = true;
            jre19Available = true;
            jre16Available = true;
            jre12Available = true;
        } else if (Jre21Compat.isSupported()) {
            instance = new Jre21Compat();
            jre22Available = false;
            jre21Available = true;
            jre20Available = true;
            jre19Available = true;
            jre16Available = true;
            jre12Available = true;
        } else if (Jre20Compat.isSupported()) {
            instance = new Jre20Compat();
            jre22Available = false;
            jre21Available = false;
            jre20Available = true;
            jre19Available = true;
            jre16Available = true;
            jre12Available = true;
        } else if (Jre19Compat.isSupported()) {
            instance = new Jre19Compat();
            jre22Available = false;
            jre21Available = false;
            jre20Available = false;
            jre19Available = true;
            jre16Available = true;
            jre12Available = true;
        } else if (Jre16Compat.isSupported()) {
            instance = new Jre16Compat();
            jre22Available = false;
            jre21Available = false;
            jre20Available = false;
            jre19Available = false;
            jre16Available = true;
            jre12Available = true;
        } else if (Jre12Compat.isSupported()) {
            instance = new Jre12Compat();
            jre22Available = false;
            jre21Available = false;
            jre20Available = false;
            jre19Available = false;
            jre16Available = false;
            jre12Available = true;
        } else {
            instance = new JreCompat();
            jre22Available = false;
            jre21Available = false;
            jre20Available = false;
            jre19Available = false;
            jre16Available = false;
            jre12Available = false;
        }
    }
}

