\name{MaximumImageFilter}
\alias{MaximumImageFilter}
\title{MaximumImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements a pixel-wise operator Max(a,b) between two images.
MaximumImageFilter}
\details{
The pixel values of the output image are the maximum between the
corresponding pixels of the two input images.
This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
See:
Maximum for the procedural interface
itk::MaximumImageFilter for the Doxygen on the original ITK class.
MaximumImageFilter}
%C++ includes: sitkMaximumImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{ MaximumImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MaximumImageFilter():}{
Destructor
}
}
}
