\name{WarpImageFilter}
\alias{WarpImageFilter}
\title{WarpImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Warps an image using an input displacement field.
WarpImageFilter}
\details{
WarpImageFilter warps an existing image with respect to a given displacement field.
A displacement field is represented as a image whose pixel type is
some vector type with at least N elements, where N is the dimension of
the input image. The vector type must support element access via
operator [].
The output image is produced by inverse mapping: the output pixels are
mapped back onto the input image. This scheme avoids the creation of
any holes and overlaps in the output image.
Each vector in the displacement field represent the distance between a
geometric point in the input space and a point in the output space
such that:
 \deqn{ p_{in} = p_{out} + d }
Typically the mapped position does not correspond to an integer pixel
position in the input image. Interpolation via an image function is
used to compute values at non-integer positions. The default
interpolation typed used is the LinearInterpolateImageFunction . The user can specify a particular interpolation function via SetInterpolator() . Note that the input interpolator must derive from base class InterpolateImageFunction .
Position mapped to outside of the input image buffer are assigned a
edge padding value.
The LargestPossibleRegion for the output is inherited from the input
displacement field. The output image spacing, origin and orientation
may be set via SetOutputSpacing, SetOutputOrigin and
SetOutputDirection. The default are respectively a vector of 1's, a
vector of 0's and an identity matrix.
This class is templated over the type of the input image, the type of
the output image and the type of the displacement field.
The input image is set via SetInput. The input displacement field is
set via SetDisplacementField.
This filter is implemented as a multithreaded filter.
WARNING:
This filter assumes that the input type, output type and displacement
field type all have the same number of dimensions.
See:
Warp for the procedural interface
itk::WarpImageFilter for the Doxygen on the original ITK class.
WarpImageFilter}
%C++ includes: sitkWarpImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &displacementField):}{
Execute the filter on the input image
}
\item{double GetEdgePaddingValue() const:}{
Get the edge padding value
}
\item{InterpolatorEnum GetInterpolator() const:}{
Get/Set the interpolator function.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetOutputDirection() const:}{
Set/Get the direction (orientation) of the output image
}
\item{std::vector< double > GetOutputOrigin() const:}{
Get the output image origin.
}
\item{std::vector< uint32_t > GetOutputSize() const:}{
Get the size of the output image.
}
\item{std::vector< double > GetOutputSpacing() const:}{
Get the output image spacing.
}
\item{Self SetEdgePaddingValue(double EdgePaddingValue):}{
Set the edge padding value
}
\item{Self SetInterpolator(InterpolatorEnum Interpolator):}{
Get/Set the interpolator function.
}
\item{Self SetOutputDirection(std::vector< double > OutputDirection):}{
Set/Get the direction (orientation) of the output image
}
\item{Self SetOutputOrigin(std::vector< double > OutputOrigin):}{
Set the output image origin.
}
\item{void SetOutputParameteresFromImage(const Image &refImage):}{
This methods sets the output size, origin, spacing and direction to
that of the provided image
}
\item{Self SetOutputSize(std::vector< uint32_t > OutputSize):}{
Set the size of the output image.
}
\item{Self SetOutputSpacing(std::vector< double > OutputSpacing):}{
Set the output image spacing.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ WarpImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~WarpImageFilter():}{
Destructor
}
}
}
