/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SearchLookup;

public class RankFeatureFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "rank_feature";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean positiveScoreImpact;

    private static RankFeatureFieldType ft(FieldMapper in) {
        return ((RankFeatureFieldMapper)in).fieldType();
    }

    private RankFeatureFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, boolean positiveScoreImpact) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.positiveScoreImpact = positiveScoreImpact;
    }

    protected RankFeatureFieldMapper clone() {
        return (RankFeatureFieldMapper)super.clone();
    }

    public RankFeatureFieldType fieldType() {
        return (RankFeatureFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        float value;
        if (context.externalValueSet()) {
            Object v = context.externalValue();
            value = RankFeatureFieldMapper.objectToFloat(v).floatValue();
        } else {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().floatValue();
        }
        if (context.doc().getByKey((Object)this.name()) != null) {
            throw new IllegalArgumentException("[rank_feature] fields do not support indexing multiple values for the same field [" + this.name() + "] in the same document");
        }
        if (!this.positiveScoreImpact) {
            value = 1.0f / value;
        }
        context.doc().addWithKey((Object)this.name(), (IndexableField)new FeatureField("_feature", this.name(), value));
    }

    private static Float objectToFloat(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    public static final class RankFeatureFieldType
    extends MappedFieldType {
        private final boolean positiveScoreImpact;

        public RankFeatureFieldType(String name, Map<String, String> meta, boolean positiveScoreImpact) {
            super(name, true, false, false, TextSearchInfo.NONE, meta);
            this.positiveScoreImpact = positiveScoreImpact;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public String typeName() {
            return RankFeatureFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_feature", this.name()));
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            throw new IllegalArgumentException("[rank_feature] fields do not support sorting, scripting or aggregating");
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context){

                protected Float parseSourceValue(Object value) {
                    return RankFeatureFieldMapper.objectToFloat(value);
                }
            };
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_feature] fields are not supported");
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> positiveScoreImpact = ParametrizedFieldMapper.Parameter.boolParam((String)"positive_score_impact", (boolean)false, m -> RankFeatureFieldMapper.ft((FieldMapper)m).positiveScoreImpact, (boolean)true);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.positiveScoreImpact, this.meta);
        }

        public RankFeatureFieldMapper build(Mapper.BuilderContext context) {
            return new RankFeatureFieldMapper(this.name, new RankFeatureFieldType(this.buildFullName(context), (Map)this.meta.getValue(), (Boolean)this.positiveScoreImpact.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), (Boolean)this.positiveScoreImpact.getValue());
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

