/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.util;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/commons/alerting/util/IndexPatternUtils;", "", "()V", "PATTERN_SPECIAL_CHARS", "", "", "containsPatternSyntax", "", "indexName", "", "common-utils"})
public final class IndexPatternUtils {
    @NotNull
    public static final IndexPatternUtils INSTANCE = new IndexPatternUtils();
    @NotNull
    private static final Set<Character> PATTERN_SPECIAL_CHARS;

    private IndexPatternUtils() {
    }

    public final boolean containsPatternSyntax(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        if (((CharSequence)indexName).length() == 0 || Intrinsics.areEqual((Object)indexName, (Object)"_all")) {
            return true;
        }
        if (StringsKt.startsWith$default((String)indexName, (String)"<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)indexName, (String)">", (boolean)false, (int)2, null)) {
            return true;
        }
        int i = 0;
        while (i < indexName.length()) {
            char currentChar = indexName.charAt(i);
            if (currentChar == '\\') {
                i += 2;
                continue;
            }
            if (PATTERN_SPECIAL_CHARS.contains(Character.valueOf(currentChar))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('+'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('\\'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('$')};
        PATTERN_SPECIAL_CHARS = SetsKt.setOf((Object[])objectArray);
    }
}

