"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                         * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                         * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                         */
class CommentsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "createComment", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.createComment', {
          alertId: req.params.alertId,
          body: req.body
        });
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateComment", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.updateComment', {
          commentId: req.params.commentId,
          body: req.body
        });
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "searchComments", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.searchComments', {
          body: req.body
        });
        const comments = resp.hits.hits.map(({
          _id,
          _source: {
            entity_id,
            content,
            created_time,
            last_updated_time,
            user
          }
        }) => ({
          id: _id,
          entity_id,
          content,
          created_time,
          last_updated_time,
          user
        }));
        return res.ok({
          body: {
            ok: true,
            resp: {
              comments
            }
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteComment", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.deleteComment', {
          commentId: req.params.commentId
        });
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = CommentsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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