"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    alertService
  } = services;
  const fieldValidations = {
    from: _configSchema.schema.maybe(_configSchema.schema.number()),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string(),
    severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
    alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
    monitorIds: _configSchema.schema.maybe(_configSchema.schema.string()),
    monitorType: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  router.get({
    path: '/api/alerting/alerts',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, alertService.getAlerts);
  const workflowFieldValidations = {
    workflowIds: _configSchema.schema.string(),
    getAssociatedAlerts: _configSchema.schema.boolean(),
    sortString: _configSchema.schema.string(),
    sortOrder: _configSchema.schema.string(),
    startIndex: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
    alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
    searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
    alertIds: _configSchema.schema.string()
  };
  router.get({
    path: '/api/alerting/workflows/alerts',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, workflowFieldValidations)
    }
  }, alertService.getWorkflowAlerts);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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