/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.function.BiConsumer;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.driver.DMSFactory;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocolNIO;
import oracle.net.ns.NSTunnelConnection;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.resolver.EZConnectResolver;

class NSTunnelConnectionImpl
implements NSTunnelConnection {
    private final String url;
    private final Properties props;
    private String tunnelAddress;
    private NIONSDataChannel dataChannel;
    private SessionAtts session;
    private NSProtocolNIO nsp;

    NSTunnelConnectionImpl(String url, Properties nsProps) throws IOException {
        EZConnectResolver resolver = EZConnectResolver.newInstance(url);
        url = resolver.getResolvedUrl();
        this.props = nsProps == null ? new Properties() : nsProps;
        resolver.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> nsProps.putIfAbsent(k, v)));
        this.url = url.startsWith("jdbc:oracle") ? url.substring(url.indexOf("@") + 1) : url;
        this.addMissingProperties();
        this.connect();
    }

    private void connect() throws IOException, NetException {
        this.nsp = new NSProtocolNIO(this.url, this.props, null, null, false, CommonDiagnosable.getInstance(), null);
        this.session = this.nsp.getSessionAttributes();
        this.session.isTunnelConnection = true;
        this.nsp.connect(null, DMSFactory.getInstance().getRoot());
        this.dataChannel = this.session.dataChannel;
        this.tunnelAddress = this.parseTunnelAddress(this.session.getConnectData());
        this.nsp.sendZDP();
    }

    private String parseTunnelAddress(String acceptConnectData) {
        if (acceptConnectData == null) {
            return null;
        }
        try {
            NVNavigator navigator = new NVNavigator();
            NVPair rootNVPair = new NVFactory().createNVPair(acceptConnectData);
            NVPair hostNVPair = navigator.findNVPairRecurse(rootNVPair, "HOST");
            NVPair portNVPair = navigator.findNVPairRecurse(rootNVPair, "PORT");
            if (hostNVPair != null && portNVPair != null) {
                return "host=" + hostNVPair.getAtom() + ";port=" + portNVPair.getAtom();
            }
        }
        catch (NLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public String tunnelAddress() {
        return this.tunnelAddress;
    }

    @Override
    public int read(ByteBuffer dstBuffer) throws IOException {
        if (!this.session.isConnected()) {
            throw new NetException(17900);
        }
        if (this.session.payloadDataBufferForRead.hasRemaining()) {
            return this.fillBuffer(dstBuffer);
        }
        while (this.session.isConnected() && !this.session.payloadDataBufferForRead.hasRemaining()) {
            this.dataChannel.readDataFromSocketChannel();
        }
        if (this.session.payloadDataBufferForRead.hasRemaining()) {
            return this.fillBuffer(dstBuffer);
        }
        throw new NetException(17800);
    }

    private int fillBuffer(ByteBuffer dstBuffer) {
        int initPos = dstBuffer.position();
        while (dstBuffer.hasRemaining() && this.session.payloadDataBufferForRead.hasRemaining()) {
            dstBuffer.put(this.session.payloadDataBufferForRead.get());
        }
        return dstBuffer.position() - initPos;
    }

    @Override
    public void write(ByteBuffer srcBuffer) throws IOException {
        if (!srcBuffer.hasRemaining()) {
            return;
        }
        while (srcBuffer.hasRemaining()) {
            this.session.prepareWriteBuffer();
            while (this.session.payloadDataBufferForWrite.hasRemaining() && srcBuffer.hasRemaining()) {
                this.session.payloadDataBufferForWrite.put(srcBuffer.get());
            }
            this.flush();
        }
    }

    private void flush() throws IOException {
        if (!this.session.isConnected()) {
            throw new NetException(17900);
        }
        this.dataChannel.writeDataToSocketChannel(0);
    }

    @Override
    public void close() throws IOException {
        this.nsp.disconnect();
    }

    @Override
    public boolean isOpen() throws IOException {
        return this.session != null && this.session.isConnected();
    }

    private void addMissingProperties() {
        this.props.putIfAbsent("oracle.net.ssl_server_dn_match", "false");
    }
}

