/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util.ipc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SignalSender {
    private static final String killCommand = "/bin/kill";
    private final long pid;

    public SignalSender(long pid) {
        if (pid <= 1L) {
            throw new IllegalArgumentException("must be greater than 1");
        }
        this.pid = pid;
    }

    public void send(SIGNAME signame) throws IOException {
        try {
            Process process = new ProcessBuilder(killCommand, "--signal", signame.name(), String.valueOf(this.pid)).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String errorString = errReader.readLine();
                throw new IOException("Cannot send signal to " + this.pid + " code " + exitCode + ": " + errorString);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("Failed to send signal to " + this.pid, e);
        }
    }

    public static enum SIGNAME {
        SIGHUP,
        SIGINT,
        SIGQUIT,
        SIGILL,
        SIGTRAP,
        SIGABRT,
        SIGBUS,
        SIGFPE,
        SIGKILL,
        SIGUSR1,
        SIGSEGV,
        SIGUSR2,
        SIGPIPE,
        SIGALRM,
        SIGTERM,
        SIGSTKFLT,
        SIGCHLD,
        SIGCONT,
        SIGSTOP,
        SIGTSTP,
        SIGTTIN,
        SIGTTOU,
        SIGURG;

    }
}

