/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleBfile.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableBfile
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETBINSTREAM_METHOD = TxnReplayableBfile.getGetBinaryStreamMethod();
    private static final Method GETBINSTREAM_LONG_METHOD = TxnReplayableBfile.getGetBinaryStreamLongMethod();
    private static final int MAX_CHUNK_SIZE = 32512;
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableBfile";

    private static final Method getGetBinaryStreamMethod() {
        try {
            return OracleBfile.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return OracleBfile.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args) {
        super.preForAll(m, receiver, args);
    }

    @Override
    @Post
    protected void postForAll(Method m) {
        this.postForAll(m, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result) {
        if (result instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m, result);
    }

    @Post
    @Methods(signatures={@Signature(name="closeFile", args={})})
    protected void postForCloseFile(Method m) {
        this.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
            this.isLogicallyClosed = true;
            try {
                connProxy.checkImplicitRequestBoundary();
            }
            catch (Throwable error) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForCloseFile", "On Bfile {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)this);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m) {
        super.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
            try {
                connProxy.checkImplicitRequestBoundary();
            }
            catch (Throwable error) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForClose", "On Bfile {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)this);
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, new Object[0]);
        try {
            OracleBfile delegate = (OracleBfile)this.getDelegate();
            InputStream delegateReturn = delegate.getDBAccess().newInputStream((OracleBfile)((Object)this), 32512, 0L);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getBinaryStream(long pos) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            OracleBfile delegate = (OracleBfile)this.getDelegate();
            InputStream delegateReturn = delegate.getDBAccess().newInputStream((OracleBfile)((Object)this), 32512, pos);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleBfile delegate = (OracleBfile)this.getDelegate();
        return delegate.getInternalConnection();
    }
}

