/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public abstract class OracleNamedType
extends OracleType
implements Serializable {
    private static final String CLASS_NAME = OracleNamedType.class.getName();
    transient OracleConnection connection;
    SQLName sqlName = null;
    transient OracleTypeADT parent = null;
    transient int idx;
    transient TypeDescriptor descriptor = null;
    String typeNameByUser;
    static String getUserTypeTreeSql = "select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
    String sqlHint = null;
    static String getAllTypeTreeSql = "select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";

    protected OracleNamedType() {
    }

    public OracleNamedType(String name, OracleConnection conn) throws SQLException {
        this.setConnectionInternal(conn);
        this.typeNameByUser = name;
        this.sqlName = new SQLName(name, conn);
    }

    protected OracleNamedType(OracleTypeADT parent, int idx, OracleConnection conn) {
        this.setConnectionInternal(conn);
        this.parent = parent;
        this.idx = idx;
    }

    public String getFullName() throws SQLException {
        return this.getFullName(false);
    }

    public String getFullName(boolean force) throws SQLException {
        String temp_fullName = null;
        if (force || this.sqlName == null) {
            if (this.parent != null && (temp_fullName = this.parent.getAttributeType(this.idx)) != null) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getFullName", "temp_fullName={0}", (String)null, null, (Object)temp_fullName);
                this.sqlName = new SQLName(temp_fullName, this.connection);
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to resolve name").fillInStackTrace();
            }
        }
        return this.sqlName.getName();
    }

    public String getSchemaName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSchema();
    }

    public String getSimpleName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSimpleName();
    }

    public boolean hasName() throws SQLException {
        return this.sqlName != null;
    }

    public OracleTypeADT getParent() throws SQLException {
        return this.parent;
    }

    public void setParent(OracleTypeADT parent) throws SQLException {
        this.parent = parent;
    }

    public int getOrder() throws SQLException {
        return this.idx;
    }

    public void setOrder(int order) throws SQLException {
        this.idx = order;
    }

    public OracleConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        this.setConnectionInternal(conn);
    }

    public void setConnectionInternal(OracleConnection conn) {
        this.connection = conn;
    }

    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int type, Map objmap) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public byte[] linearize(Datum data) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public void setDescriptor(TypeDescriptor desc) throws SQLException {
        this.descriptor = desc;
    }

    public int getTypeVersion() {
        return 1;
    }

    String getTypeName(String ownerName, String packageName, String sqlName) {
        String typeName = packageName == null || packageName.isEmpty() ? sqlName : packageName + "." + sqlName;
        return ownerName == null || ownerName.isEmpty() ? typeName : SQLName.getTypeName(ownerName, typeName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeUTF(this.getFullName());
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String name = in.readUTF();
        try {
            this.sqlName = new SQLName(name, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.parent = null;
        this.idx = -1;
    }

    public void fixupConnection(OracleConnection fixupConn) throws SQLException {
        if (this.connection == null) {
            this.setConnection(fixupConn);
        }
    }

    @Override
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        this.printXML(pw, indent, false);
    }

    @Override
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        for (int i = 0; i < indent; ++i) {
            pw.print("  ");
        }
        pw.println("<OracleNamedType/>");
    }

    @Override
    public void initNamesRecursively() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Map typesTreeMap = this.createTypesTreeMap();
            if (typesTreeMap.size() > 0) {
                this.initChildNamesRecursively(typesTreeMap);
            }
        }
    }

    @Override
    public void setNames(String schemaName, String typeName) throws SQLException {
        this.sqlName = new SQLName(schemaName, typeName, this.connection);
    }

    public void setSqlName(SQLName x) {
        this.sqlName = x;
    }

    public Map createTypesTreeMap() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Map nodeMap = null;
            String currentUserName = this.connection.getDefaultSchemaNameForNamedTypes();
            if (this.sqlName.getSchema().equals(currentUserName)) {
                nodeMap = this.getNodeMapFromUserTypes();
            }
            if (nodeMap == null) {
                nodeMap = this.getNodeMapFromAllTypes();
            }
            Map map = nodeMap;
            return map;
        }
    }

    String getSqlHint() throws SQLException {
        if (this.sqlHint == null) {
            this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
        }
        return this.sqlHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromUserTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> nodeMap = new HashMap<SQLName, TypeTreeElement>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        this.connection.beginNonRequestCalls();
        try {
            pstmt = this.connection.prepareStatement(this.getSqlHint() + getUserTypeTreeSql);
            pstmt.setString(1, this.sqlName.getSimpleName());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                int depth = rst.getInt(1);
                String parentTypeName = rst.getString(2);
                String childTypeName = rst.getString(3);
                int attrNumber = rst.getInt(4);
                String childTypeOwner = rst.getString(5);
                if (childTypeOwner != null && !childTypeOwner.equals(this.sqlName.getSchema())) {
                    nodeMap = null;
                    break;
                }
                if (parentTypeName.length() <= 0) continue;
                SQLName parentSqlName = new SQLName(this.sqlName.getSchema(), parentTypeName, this.connection);
                TypeTreeElement node = null;
                if (nodeMap.containsKey(parentSqlName)) {
                    node = (TypeTreeElement)nodeMap.get(parentSqlName);
                } else {
                    node = new TypeTreeElement(this.sqlName.getSchema(), parentTypeName);
                    nodeMap.put(parentSqlName, node);
                }
                node.putChild(this.sqlName.getSchema(), childTypeName, attrNumber);
            }
        }
        finally {
            if (rst != null) {
                rst.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            this.connection.endNonRequestCalls();
        }
        return nodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromAllTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> nodeMap = new HashMap<SQLName, TypeTreeElement>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        this.connection.beginNonRequestCalls();
        try {
            pstmt = this.connection.prepareStatement(this.getSqlHint() + getAllTypeTreeSql);
            pstmt.setString(1, this.sqlName.getSimpleName());
            pstmt.setString(2, this.sqlName.getSchema());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String parentTypeName = rst.getString(1);
                String parentOwnerName = rst.getString(2);
                String childTypeName = rst.getString(3);
                int attrNumber = rst.getInt(4);
                String childOwnerName = rst.getString(5);
                if (childOwnerName == null) {
                    childOwnerName = "SYS";
                }
                if (parentTypeName.length() <= 0) continue;
                SQLName parentSQLName = new SQLName(parentOwnerName, parentTypeName, this.connection);
                TypeTreeElement node = null;
                if (nodeMap.containsKey(parentSQLName)) {
                    node = (TypeTreeElement)nodeMap.get(parentSQLName);
                } else {
                    node = new TypeTreeElement(parentOwnerName, parentTypeName);
                    nodeMap.put(parentSQLName, node);
                }
                node.putChild(childOwnerName, childTypeName, attrNumber);
            }
        }
        finally {
            if (rst != null) {
                rst.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            this.connection.endNonRequestCalls();
        }
        return nodeMap;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

