/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public interface TraceKey {
    public static final AtomicInteger NEXT_INDEX = new AtomicInteger(0);
    public static final Vector<TraceKey> INDEX_TO_KEY = new Vector(16);

    public static int nextIndex() {
        return NEXT_INDEX.getAndIncrement();
    }

    public static int maxIndex() {
        return NEXT_INDEX.get();
    }

    public static void register(TraceKey k) {
        INDEX_TO_KEY.ensureCapacity(k.index());
        INDEX_TO_KEY.add(k.index(), k);
    }

    public static Iterator<TraceKey> iterator() {
        return INDEX_TO_KEY.iterator();
    }

    public int index();

    public String keyName();

    default public String namespace() {
        return null;
    }

    default public String propertyName() {
        return this.keyName();
    }

    default public String xmlAttributeName() {
        return this.propertyName();
    }
}

