/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import java.util.function.Supplier;
import oracle.jdbc.driver.oauth.JsonWebToken;
import oracle.jdbc.logging.annotations.Blind;

public interface AccessToken {
    public static AccessToken createJsonWebToken(@Blind char[] token, @Blind PrivateKey privateKey) {
        try {
            return JsonWebToken.createProofOfPossessionToken(Objects.requireNonNull(token, "token is null"), Objects.requireNonNull(privateKey, "privateKey is null"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException);
        }
    }

    public static AccessToken createJsonWebToken(@Blind char[] token) {
        return JsonWebToken.createBearerToken(Objects.requireNonNull(token, "token is null"));
    }

    public static Supplier<? extends AccessToken> createJsonWebTokenCache(Supplier<? extends AccessToken> tokenSupplier) {
        return JsonWebToken.createCache(Objects.requireNonNull(tokenSupplier, "tokenSupplier is null"));
    }
}

