/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class MappedGetter<KEY, VALUE> {
    private volatile Map<KEY, VALUE> map = new HashMap<KEY, VALUE>();
    private final ReentrantLock lock = new ReentrantLock(false);

    public VALUE computeIfAbsent(KEY key, Function<KEY, VALUE> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, UnaryOperator.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE computeIfAbsent(KEY key, Function<KEY, VALUE> mappingFunction, UnaryOperator<KEY> keyConverter) {
        assert (null != key) : "key should be non-null";
        assert (null != mappingFunction) : "mapping function should be non-null";
        VALUE v = this.map.get(key);
        if (null == v) {
            try {
                this.lock.lock();
                v = this.map.get(key);
                if (null == v) {
                    HashMap<KEY, VALUE> newMap = new HashMap<KEY, VALUE>(this.map);
                    v = newMap.computeIfAbsent(keyConverter.apply(key), mappingFunction);
                    this.map = newMap;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return v;
    }

    public void forEach(BiConsumer<KEY, VALUE> action) {
        Map<KEY, VALUE> curMap = this.map;
        curMap.forEach(action);
    }

    public String toString() {
        Map<KEY, VALUE> curMap = this.map;
        return curMap.toString();
    }

    public int size() {
        return this.map.size();
    }
}

