/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.ons.NotificationManager;
import oracle.ons.spi.ONSSocket;
import oracle.ons.spi.SocketCallback;
import oracle.ons.spi.SocketManager;

public class DefaultSocketManager
implements SocketManager {
    @Override
    public ONSSocket createSocket(String string, int n, int n2, SocketCallback socketCallback) throws IOException {
        DefaultSocket defaultSocket = new DefaultSocket(new Socket());
        defaultSocket.socket.connect(new InetSocketAddress(string, n), n2);
        defaultSocket.socket.setSoTimeout(n2);
        new ListeningThread(defaultSocket, socketCallback, String.format("ONS Listener Thread to %s:%d", string, n)).start();
        return defaultSocket;
    }

    @Override
    public ONSSocket createSocket(String string, int n, int n2, SocketCallback socketCallback, SSLSocketFactory sSLSocketFactory) throws IOException {
        Socket socket = null;
        Socket socket2 = null;
        DefaultSocket defaultSocket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(string, n), n2);
            socket2 = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
            defaultSocket = new DefaultSocket(socket2);
            ((SSLSocket)socket2).startHandshake();
        }
        catch (Exception exception) {
            if (defaultSocket != null) {
                defaultSocket.close();
            }
            if (socket2 != null) {
                socket2.close();
            }
            if (socket != null) {
                socket.close();
            }
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            NotificationManager.getNotificationManager();
            NotificationManager.logger.finest("Exception stack trace:\n" + stringWriter.toString());
            NotificationManager.getNotificationManager();
            NotificationManager.logger.fine("SSL Connection failed");
            NotificationManager.getNotificationManager();
            NotificationManager.logger.fine("Creating non-SSL Connection");
            return this.createSocket(string, n, n2, socketCallback);
        }
        new ListeningThread(defaultSocket, socketCallback, String.format("ONS Listener Thread to %s:%d (SSL)", string, n)).start();
        return defaultSocket;
    }

    private static class ListeningThread
    extends Thread {
        static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final DefaultSocket socket;
        private final SocketCallback callback;
        private int data_len;

        public ListeningThread(DefaultSocket defaultSocket, SocketCallback socketCallback, String string) {
            super(string);
            this.socket = defaultSocket;
            this.callback = socketCallback;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block6: {
                try {
                    InputStream inputStream = this.socket.socket.getInputStream();
                    while (this.socket.socket.isConnected()) {
                        try {
                            this.data_len = inputStream.read(this.buffer);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            continue;
                        }
                        if (this.data_len > 0) {
                            this.callback.onDataAvailable(this.buffer, 0, this.data_len);
                            continue;
                        }
                        if (this.data_len != -1) continue;
                        if (this.socket.shuttingDown) break;
                        throw new EOFException("Socket closed by remote side");
                    }
                }
                catch (Exception exception) {
                    if (this.socket.shuttingDown) break block6;
                    this.callback.hasException(exception);
                }
            }
        }
    }

    private static class DefaultSocket
    implements ONSSocket {
        public Socket socket;
        public volatile boolean shuttingDown = false;

        public DefaultSocket(Socket socket) {
            this.socket = socket;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }

        @Override
        public void close() throws IOException {
            if (!this.socket.isClosed()) {
                this.shuttingDown = true;
                this.socket.close();
            }
        }
    }
}

