/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.ee.WebAppClassLoading;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.nested.ErrorHandler;
import org.eclipse.jetty.ee8.nested.HandlerWrapper;
import org.eclipse.jetty.ee8.nested.SessionHandler;
import org.eclipse.jetty.ee8.security.ConstraintAware;
import org.eclipse.jetty.ee8.security.ConstraintMapping;
import org.eclipse.jetty.ee8.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee8.security.SecurityHandler;
import org.eclipse.jetty.ee8.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHandler;
import org.eclipse.jetty.ee8.webapp.ClassMatcher;
import org.eclipse.jetty.ee8.webapp.Configuration;
import org.eclipse.jetty.ee8.webapp.Configurations;
import org.eclipse.jetty.ee8.webapp.MetaData;
import org.eclipse.jetty.ee8.webapp.Origin;
import org.eclipse.jetty.ee8.webapp.WebAppClassLoader;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ClassLoaderDump;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Web Application ContextHandler")
public class WebAppContext
extends ServletContextHandler
implements WebAppClassLoader.Context,
Deployable {
    static final Logger LOG = LoggerFactory.getLogger(WebAppContext.class);
    public static final String WEB_DEFAULTS_XML = "org/eclipse/jetty/ee8/webapp/webdefault-ee8.xml";
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final String SERVER_SYS_CLASSES = "org.eclipse.jetty.webapp.systemClasses";
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final String SERVER_SRV_CLASSES = "org.eclipse.jetty.webapp.serverClasses";
    private static final String[] __dftProtectedTargets = new String[]{"/WEB-INF", "/META-INF"};
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final ClassMatcher __dftSystemClasses = new ClassMatcher(WebAppClassLoading.DEFAULT_PROTECTED_CLASSES);
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final ClassMatcher __dftServerClasses = new ClassMatcher(WebAppClassLoading.DEFAULT_HIDDEN_CLASSES);
    private final ClassMatcher _systemClasses = new ClassMatcher(WebAppClassLoading.getProtectedClasses((Environment)ServletContextHandler.ENVIRONMENT));
    private final ClassMatcher _serverClasses = new ClassMatcher(WebAppClassLoading.getHiddenClasses((Environment)ServletContextHandler.ENVIRONMENT));
    private Configurations _configurations;
    private String _defaultsDescriptor = "org/eclipse/jetty/ee8/webapp/webdefault-ee8.xml";
    private String _descriptor = null;
    private final List<String> _overrideDescriptors = new ArrayList<String>();
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _copyWebInf = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.eclipse.jetty.server.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _contextWhiteList = null;
    private String _war;
    private List<Resource> _extraClasspath;
    private Throwable _unavailableException;
    private Map<String, String> _resourceAliases;
    private ClassLoader _initialClassLoader;
    private boolean _configurationDiscovered = true;
    private boolean _allowDuplicateFragmentNames = false;
    private boolean _throwUnavailableOnStartupException = false;
    private MetaData _metadata = new MetaData();
    private boolean _defaultContextPath = true;

    public static WebAppContext getCurrentWebAppContext() {
        ContextHandler handler;
        ContextHandler.APIContext context = ContextHandler.getCurrentContext();
        if (context != null && (handler = context.getContextHandler()) instanceof WebAppContext) {
            return (WebAppContext)handler;
        }
        return null;
    }

    public WebAppContext() {
        this(null, null, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
    }

    public WebAppContext(String webApp, String contextPath) {
        this(null, contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(Resource webApp, String contextPath) {
        this(null, contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWarResource(webApp);
    }

    public WebAppContext(Handler.Container parent, String webApp, String contextPath) {
        this(parent, contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(Handler.Container parent, Resource webApp, String contextPath) {
        this(parent, contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWarResource(webApp);
    }

    public WebAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(null, null, sessionHandler, securityHandler, servletHandler, errorHandler, 0);
    }

    public WebAppContext(Handler.Container parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler, int options) {
        super(null, contextPath, sessionHandler, securityHandler, servletHandler, errorHandler, options);
        this._apiContext = new Context();
        this.setErrorHandler((ErrorHandler)(errorHandler != null ? errorHandler : new ErrorPageErrorHandler()));
        this.setProtectedTargets(__dftProtectedTargets);
        HandlerWrapper.setAsParent((Handler.Container)parent, (Handler)this.get());
    }

    public void initializeDefaults(Map<String, String> properties) {
        block24: for (String property : properties.keySet()) {
            String value = properties.get(property);
            if (LOG.isDebugEnabled()) {
                LOG.debug("init {}: {}", (Object)property, (Object)value);
            }
            switch (property) {
                case "jetty.deploy.war": {
                    this.setWar(value);
                    continue block24;
                }
                case "jetty.deploy.tempDir": {
                    this.setTempDirectory(IO.asFile((Object)value));
                    continue block24;
                }
                case "jetty.deploy.configurationClasses": {
                    this.setConfigurationClasses(value == null ? null : value.split(","));
                    continue block24;
                }
                case "jetty.deploy.containerScanJarPattern": {
                    this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", value);
                    continue block24;
                }
                case "jetty.deploy.extractWars": {
                    this.setExtractWAR(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "jetty.deploy.parentLoaderPriority": {
                    this.setParentLoaderPriority(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "jetty.deploy.webInfScanJarPattern": {
                    this.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", value);
                    continue block24;
                }
                case "jetty.deploy.defaultsDescriptor": {
                    this.setDefaultsDescriptor(value);
                    continue block24;
                }
                case "jetty.deploy.servletContainerInitializerExclusionPattern": {
                    this.setAttribute("org.eclipse.jetty.containerInitializerExclusionPattern", value);
                    continue block24;
                }
                case "jetty.deploy.servletContainerInitializerOrder": {
                    this.setAttribute("org.eclipse.jetty.containerInitializerOrder", value);
                    continue block24;
                }
            }
            if (!LOG.isDebugEnabled() || !StringUtil.isNotBlank((String)value)) continue;
            LOG.debug("unknown property {}={}", (Object)property, (Object)value);
        }
        this._defaultContextPath = true;
    }

    public boolean isContextPathDefault() {
        return this._defaultContextPath;
    }

    public void setContextPath(String contextPath) {
        super.setContextPath(contextPath);
        this._defaultContextPath = false;
    }

    public void setDefaultContextPath(String contextPath) {
        super.setContextPath(contextPath);
        this._defaultContextPath = true;
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        ClassLoader cl = this.getClassLoader();
        if (cl instanceof WebAppClassLoader && displayName != null) {
            ((WebAppClassLoader)cl).setName(displayName);
        }
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap<String, String>(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map<String, String> getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map<String, String> map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String path) {
        if (this._resourceAliases == null) {
            return null;
        }
        Object alias = this._resourceAliases.get(path);
        int slash = path.length();
        while (alias == null && (slash = path.lastIndexOf("/", slash - 1)) >= 0) {
            String match = this._resourceAliases.get(path.substring(0, slash + 1));
            if (match == null) continue;
            alias = match + path.substring(slash + 1);
        }
        return alias;
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases.remove(alias);
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        String name = this.getDisplayName();
        if (name == null) {
            name = this.getContextPath();
        }
        if (classLoader instanceof WebAppClassLoader && this.getDisplayName() != null) {
            ((WebAppClassLoader)classLoader).setName(name);
        }
    }

    public ResourceFactory getResourceFactory() {
        return ResourceFactory.of((Container)this);
    }

    public Resource getResource(String pathInContext) throws MalformedURLException {
        if (pathInContext == null || !pathInContext.startsWith("/")) {
            throw new MalformedURLException(pathInContext);
        }
        MalformedURLException mue = null;
        Resource resource = null;
        int loop = 0;
        while (pathInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(pathInContext);
                if (Resources.exists((Resource)resource)) {
                    return resource;
                }
                pathInContext = this.getResourceAlias(pathInContext);
            }
            catch (MalformedURLException e) {
                LOG.trace("IGNORED", (Throwable)e);
                if (mue != null) continue;
                mue = e;
            }
        }
        if (mue != null) {
            throw mue;
        }
        return resource;
    }

    public boolean isConfigurationDiscovered() {
        return this._configurationDiscovered;
    }

    public void setConfigurationDiscovered(boolean discovered) {
        this._configurationDiscovered = discovered;
    }

    public void preConfigure() throws Exception {
        for (Configuration configuration : Configurations.getKnown()) {
            this._serverClasses.include(configuration.getServerClasses().getInclusions());
        }
        this.loadConfigurations();
        this._configurations.sort();
        for (Configuration configuration : this._configurations) {
            this._systemClasses.add(configuration.getSystemClasses().getPatterns());
            this._serverClasses.exclude(configuration.getServerClasses().getExclusions());
        }
        this._initialClassLoader = this.getClassLoader();
        ClassLoader loader = this.configureClassLoader(this._initialClassLoader);
        if (loader != this._initialClassLoader) {
            this.setClassLoader(loader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread Context classloader {}", (Object)loader);
            for (loader = loader.getParent(); loader != null; loader = loader.getParent()) {
                LOG.debug("Parent class loader: {} ", (Object)loader);
            }
        }
        this._configurations.preConfigure(this);
    }

    protected ClassLoader configureClassLoader(ClassLoader loader) throws IOException {
        if (loader instanceof WebAppClassLoader) {
            return loader;
        }
        return new WebAppClassLoader(loader, this);
    }

    public boolean configure() throws Exception {
        return this._configurations.configure(this);
    }

    public void postConfigure() throws Exception {
        this._configurations.postConfigure(this);
    }

    protected void doStart() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            this._metadata.setAllowDuplicateFragmentNames(this.isAllowDuplicateFragmentNames());
            Boolean validate = (Boolean)this.getAttribute("org.eclipse.jetty.ee8.webapp.validateXml");
            this._metadata.setValidateXml(validate != null && validate != false);
            this.wrapConfigurations();
            this.preConfigure();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            super.doStart();
            this.postConfigure();
            if (this.isLogUrlOnStart()) {
                this.dumpUrl();
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed startup of context {}", (Object)this, (Object)t);
            this._unavailableException = t;
            this.setAvailable(false);
            if (this.isThrowUnavailableOnStartupException()) {
                throw t;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void wrapConfigurations() {
        Collection wrappers = this.getBeans(Configuration.WrapperFunction.class);
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        ArrayList<Configuration> configs = new ArrayList<Configuration>(this._configurations.getConfigurations());
        this._configurations.clear();
        Iterator iterator = configs.iterator();
        while (iterator.hasNext()) {
            Configuration config;
            Configuration wrapped = config = (Configuration)iterator.next();
            for (Configuration.WrapperFunction wrapperFunction : this.getBeans(Configuration.WrapperFunction.class)) {
                wrapped = wrapperFunction.wrapConfiguration(wrapped);
            }
            this._configurations.add(wrapped);
        }
    }

    public void destroy() {
        Throwable multiException = null;
        if (this._configurations != null) {
            for (Configuration configuration : this._configurations) {
                try {
                    configuration.destroy(this);
                }
                catch (Exception e) {
                    multiException = ExceptionUtil.combine(multiException, (Throwable)e);
                }
            }
        }
        this._configurations = null;
        super.destroy();
        ExceptionUtil.ifExceptionThrowUnchecked(multiException);
    }

    private void dumpUrl() {
        Object[] connectors = this.getServer().getConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            Object displayName = this.getDisplayName();
            if (displayName == null) {
                displayName = "WebApp@" + Arrays.hashCode(connectors);
            }
            LOG.info("{} at http://{}{}", new Object[]{displayName, connectors[i].toString(), this.getContextPath()});
        }
    }

    @ManagedAttribute(value="configuration classes used to configure webapp", readonly=true)
    public String[] getConfigurationClasses() {
        this.loadConfigurations();
        return this._configurations.toArray();
    }

    public Configurations getConfigurations() {
        this.loadConfigurations();
        return this._configurations;
    }

    @ManagedAttribute(value="default web.xml deascriptor applied before standard web.xml", readonly=true)
    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        if (this._overrideDescriptors.size() != 1) {
            return null;
        }
        return this._overrideDescriptors.get(0);
    }

    @ManagedAttribute(value="web.xml deascriptors applied after standard web.xml", readonly=true)
    public List<String> getOverrideDescriptors() {
        return Collections.unmodifiableList(this._overrideDescriptors);
    }

    @Override
    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void setServerClassMatcher(ClassMatcher serverClasses) {
        this._serverClasses.clear();
        this._serverClasses.add(serverClasses.getPatterns());
    }

    public void setSystemClassMatcher(ClassMatcher systemClasses) {
        this._systemClasses.clear();
        this._systemClasses.add(systemClasses.getPatterns());
    }

    public void addServerClassMatcher(ClassMatcher serverClasses) {
        this._serverClasses.add(serverClasses.getPatterns());
    }

    public void addSystemClassMatcher(ClassMatcher systemClasses) {
        this._systemClasses.add(systemClasses.getPatterns());
    }

    public ClassMatcher getSystemClassMatcher() {
        return this._systemClasses;
    }

    public ClassMatcher getServerClassMatcher() {
        return this._serverClasses;
    }

    @ManagedAttribute(value="classes and packages protected by context classloader", readonly=true)
    public String[] getSystemClasses() {
        return this._systemClasses.getPatterns();
    }

    @ManagedAttribute(value="classes and packages hidden by the context classloader", readonly=true)
    public String[] getServerClasses() {
        return this._serverClasses.getPatterns();
    }

    public boolean isHiddenClass(Class<?> clazz) {
        return this.isServerClass(clazz);
    }

    public boolean isProtectedClass(Class<?> clazz) {
        return this.isSystemClass(clazz);
    }

    public boolean isServerClass(Class<?> clazz) {
        return this._serverClasses.match(clazz);
    }

    public boolean isSystemClass(Class<?> clazz) {
        return this._systemClasses.match(clazz);
    }

    @Override
    public boolean isServerResource(String name, URL url) {
        return this._serverClasses.match(name, url);
    }

    @Override
    public boolean isSystemResource(String name, URL url) {
        return this._systemClasses.match(name, url);
    }

    public void setServer(Server server) {
        super.setServer(server);
        if (server != null) {
            this._systemClasses.add(WebAppClassLoading.getProtectedClasses((Server)server).getPatterns());
            this._serverClasses.add(WebAppClassLoading.getHiddenClasses((Server)server).getPatterns());
        }
    }

    @ManagedAttribute(value="war file location", readonly=true)
    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        if (super.getBaseResource() == null) {
            return null;
        }
        Resource webInf = super.getBaseResource().resolve("WEB-INF/");
        if (Resources.isReadableDirectory((Resource)webInf)) {
            return webInf;
        }
        return null;
    }

    @ManagedAttribute(value="web application distributable")
    public boolean isDistributable() {
        return this._distributable;
    }

    @ManagedAttribute(value="extract war", readonly=true)
    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    @ManagedAttribute(value="webdir copied on deploy (allows hot replacement on windows)", readonly=true)
    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isCopyWebInf() {
        return this._copyWebInf;
    }

    @Override
    @ManagedAttribute(value="parent classloader given priority", readonly=true)
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    protected void loadConfigurations() {
        if (this._configurations != null) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._configurations = this.newConfigurations();
    }

    protected Configurations newConfigurations() {
        Configurations configurations = new Configurations();
        configurations.add(Configurations.getServerDefault(this.getServer()).toArray());
        return configurations;
    }

    public String toString() {
        if (this._war != null) {
            return super.toString() + "{" + this._war + "}";
        }
        return super.toString();
    }

    public void dump(Appendable out, String indent) throws IOException {
        String name;
        ArrayList systemClasses = null;
        if (this._systemClasses != null) {
            systemClasses = new ArrayList(this._systemClasses);
            Collections.sort(systemClasses);
        }
        ArrayList serverClasses = null;
        if (this._serverClasses != null) {
            serverClasses = new ArrayList(this._serverClasses);
            Collections.sort(serverClasses);
        }
        if ((name = this.getDisplayName()) == null) {
            if (this._war != null) {
                int webapps = this._war.indexOf("/webapps/");
                name = webapps >= 0 ? this._war.substring(webapps + 8) : this._war;
            } else if (this.getResourceBase() != null) {
                name = this.getResourceBase();
                int webapps = name.indexOf("/webapps/");
                if (webapps >= 0) {
                    name = name.substring(webapps + 8);
                }
            } else {
                name = this.getClass().getSimpleName();
            }
        }
        name = String.format("%s@%x", name, this.hashCode());
        this.dumpObjects(out, indent, new Object[]{Dumpable.named((String)"environment", (Object)ContextHandler.ENVIRONMENT.getName()), Dumpable.named((String)"maxFormKeys ", (Object)this.getMaxFormKeys()), Dumpable.named((String)"maxFormContentSize ", (Object)this.getMaxFormContentSize()), new ClassLoaderDump(this.getClassLoader()), new DumpableCollection("Systemclasses " + name, systemClasses), new DumpableCollection("Serverclasses " + name, serverClasses), new DumpableCollection("Configurations " + name, (Collection)this._configurations), new DumpableCollection("Handler attributes " + name, this.getAttributes().asAttributeMap().entrySet()), new DumpableCollection("Context attributes " + name, this.getServletContext().getContextHandler().asAttributeMap().entrySet()), new DumpableCollection("Environment attributes " + name, ContextHandler.ENVIRONMENT.asAttributeMap().entrySet()), new DumpableCollection("EventListeners " + String.valueOf(this), (Collection)this.getEventListeners()), new DumpableCollection("Initparams " + name, this.getInitParams().entrySet())});
    }

    public void setConfigurationClasses(String[] configurations) {
        if (this._configurations == null) {
            this._configurations = new Configurations();
        }
        this._configurations.set(configurations);
    }

    public void setConfigurationClasses(List<String> configurations) {
        this.setConfigurationClasses(configurations.toArray(new String[0]));
    }

    public void setConfigurations(Configuration[] configurations) {
        if (this._configurations == null) {
            this._configurations = new Configurations();
        }
        this._configurations.set(configurations);
    }

    public void addConfiguration(Configuration ... configuration) {
        this.loadConfigurations();
        this._configurations.add(configuration);
    }

    public <T> T getConfiguration(Class<? extends T> configClass) {
        this.loadConfigurations();
        return this._configurations.get(configClass);
    }

    public void removeConfiguration(Configuration ... configurations) {
        if (this._configurations != null) {
            this._configurations.remove(configurations);
        }
    }

    public void removeConfiguration(Class<? extends Configuration> ... configurations) {
        if (this._configurations != null) {
            this._configurations.remove(configurations);
        }
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.add(overrideDescriptor);
    }

    public void setOverrideDescriptors(List<String> overrideDescriptors) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.addAll(overrideDescriptors);
    }

    public void addOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.add(overrideDescriptor);
    }

    @ManagedAttribute(value="standard web.xml descriptor", readonly=true)
    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener) && this._sessionHandler != null) {
                this._sessionHandler.removeEventListener(listener);
            }
            return true;
        }
        return false;
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setCopyWebDir(boolean copy) {
        this._copyDir = copy;
    }

    public void setCopyWebInf(boolean copyWebInf) {
        this._copyWebInf = copyWebInf;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setContextWhiteList(String ... contextWhiteList) {
        this._contextWhiteList = contextWhiteList;
    }

    public void setTempDirectory(File dir) {
        this.getCoreContextHandler().setTempDirectory(dir);
    }

    @ManagedAttribute(value="temporary directory location", readonly=true)
    public File getTempDirectory() {
        return this.getCoreContextHandler().getTempDirectory();
    }

    protected void makeTempDirectory() throws Exception {
        this.getCoreContextHandler().makeTempDirectory();
    }

    protected String getCanonicalNameForTmpDir() {
        return this.getCoreContextHandler().getCanonicalNameForTmpDir();
    }

    public Resource getNestedResourceForTempDirName() {
        Resource resource = super.getNestedResourceForTempDirName();
        if (resource == null) {
            if (this.getWar() == null || this.getWar().length() == 0) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            resource = this.getResourceFactory().newResource(this.getWar());
        }
        return resource;
    }

    public void setPersistTempDirectory(boolean persist) {
        this.getCoreContextHandler().setTempDirectoryPersistent(persist);
    }

    public boolean isPersistTempDirectory() {
        return this.getCoreContextHandler().isTempDirectoryPersistent();
    }

    public void setWar(String war) {
        this._war = war;
    }

    public void setWarResource(Resource war) {
        this.setWar(war == null ? null : war.toString());
    }

    @Override
    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public List<Resource> getExtraClasspath() {
        return this._extraClasspath == null ? Collections.emptyList() : this._extraClasspath;
    }

    public void setExtraClasspath(String extraClasspath) throws IOException {
        this.setExtraClasspath(this.getResourceFactory().split(extraClasspath));
    }

    public void setExtraClasspath(List<Resource> extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean logOnStart) {
        this._logUrlOnStart = logOnStart;
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this._allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this._allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public void setThrowUnavailableOnStartupException(boolean throwIfStartupException) {
        this._throwUnavailableOnStartupException = throwIfStartupException;
    }

    public boolean isThrowUnavailableOnStartupException() {
        return this._throwUnavailableOnStartupException;
    }

    protected void startContext() throws Exception {
        if (this.configure()) {
            this._metadata.resolve(this);
            this.startWebapp();
        }
    }

    protected void stopContext() throws Exception {
        this.stopWebapp();
        try {
            int i = this._configurations.size();
            while (i-- > 0) {
                this._configurations.get(i).deconfigure(this);
            }
            if (this._metadata != null) {
                this._metadata.clear();
            }
            this._metadata = new MetaData();
        }
        finally {
            ClassLoader loader = this.getClassLoader();
            if (loader != this._initialClassLoader) {
                if (loader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)loader;
                    urlClassLoader.close();
                }
                this.setClassLoader(this._initialClassLoader);
            }
            this._unavailableException = null;
        }
    }

    protected void startWebapp() throws Exception {
        super.startContext();
    }

    protected void stopWebapp() throws Exception {
        super.stopContext();
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        HashSet<String> unchangedURLMappings = new HashSet<String>();
        Collection pathMappings = registration.getMappings();
        if (pathMappings != null) {
            ConstraintSecurityHandler.createConstraint((String)registration.getName(), (HttpConstraintElement)servletSecurityElement);
            block5: for (String pathSpec : pathMappings) {
                Origin origin = this.getMetaData().getOrigin("constraint.url." + pathSpec);
                switch (origin) {
                    case NotSet: {
                        List mappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                        for (ConstraintMapping m : mappings) {
                            ((ConstraintAware)this.getSecurityHandler()).addConstraintMapping(m);
                        }
                        ((ConstraintAware)this.getSecurityHandler()).checkPathsWithUncoveredHttpMethods();
                        this.getMetaData().setOriginAPI("constraint.url." + pathSpec);
                        continue block5;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: 
                    case WebFragment: {
                        unchangedURLMappings.add(pathSpec);
                        continue block5;
                    }
                    case Annotation: 
                    case API: {
                        List constraintMappings = ConstraintSecurityHandler.removeConstraintMappingsForPath((String)pathSpec, (List)((ConstraintAware)this.getSecurityHandler()).getConstraintMappings());
                        List freshMappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                        constraintMappings.addAll(freshMappings);
                        ((ConstraintSecurityHandler)this.getSecurityHandler()).setConstraintMappings(constraintMappings);
                        ((ConstraintAware)this.getSecurityHandler()).checkPathsWithUncoveredHttpMethods();
                        continue block5;
                    }
                }
                throw new IllegalStateException(origin.toString());
            }
        }
        return unchangedURLMappings;
    }

    public MetaData getMetaData() {
        return this._metadata;
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public static void addServerClasses(Attributes attributes, String ... patterns) {
        WebAppClassLoading.addHiddenClasses((Attributes)attributes, (String[])patterns);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public static void addSystemClasses(Attributes attributes, String ... patterns) {
        WebAppClassLoading.addProtectedClasses((Attributes)attributes, (String[])patterns);
    }

    public class Context
    extends ServletContextHandler.ServletAPIContext {
        public Context() {
            super((ServletContextHandler)WebAppContext.this);
        }

        public void checkListener(Class<? extends EventListener> listener) throws IllegalStateException {
            try {
                super.checkListener(listener);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Inappropriate listener type " + listener.getName());
            }
        }

        public URL getResource(String path) throws MalformedURLException {
            if (path == null) {
                return null;
            }
            try {
                Resource resource = WebAppContext.this.getResource(path);
                if (Resources.missing((Resource)resource)) {
                    return null;
                }
                for (Resource r : resource) {
                    if (!Resources.exists((Resource)r)) continue;
                    return r.getURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw (MalformedURLException)new MalformedURLException(path).initCause(e);
            }
            return null;
        }

        public ServletContext getContext(String uripath) {
            ServletContext servletContext = super.getContext(uripath);
            if (servletContext != null && WebAppContext.this._contextWhiteList != null) {
                for (String context : WebAppContext.this._contextWhiteList) {
                    if (!context.equals(uripath)) continue;
                    return servletContext;
                }
                return null;
            }
            return servletContext;
        }
    }
}

