/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import org.jsmpp.util.TimeFormatter;

public class AbsoluteTimeFormatter
implements TimeFormatter {
    private static final String DATE_FORMAT = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}{6,number,0}{7,number,00}{8}";

    @Override
    public String format(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        int year = calendar.get(1) - 2000;
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int tenthsOfSecond = calendar.get(14) / 100;
        int offset = calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
        char sign = offset >= 0 ? (char)'+' : '-';
        int timeDiff = Math.abs(offset) / 900000;
        return AbsoluteTimeFormatter.format(year, month, day, hour, minute, second, tenthsOfSecond, timeDiff, Character.valueOf(sign));
    }

    @Override
    public String format(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.format(cal);
    }

    public static final String format(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second, int tenthsOfSecond, int timeDiff, Character sign) {
        Object[] args = new Object[]{year, month, day, hour, minute, second, tenthsOfSecond, timeDiff, sign};
        return MessageFormat.format(DATE_FORMAT, args);
    }
}

