/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.UserAgent;

public class BrowserDetect {
    private static final Log log = LogFactory.getLog(BrowserDetect.class);

    public static int getConnectionLimit(HttpServletRequest request) {
        if (BrowserDetect.atLeast(request, UserAgent.IE, 8)) {
            return 6;
        }
        if (BrowserDetect.atLeast(request, UserAgent.Firefox, 3)) {
            return 6;
        }
        if (BrowserDetect.atLeast(request, UserAgent.AppleWebKit, 8)) {
            return 4;
        }
        if (BrowserDetect.atLeast(request, UserAgent.Opera, 9)) {
            return 4;
        }
        return 2;
    }

    public static boolean supportsComet(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return !userAgent.contains("Symbian");
    }

    public static boolean atLeast(HttpServletRequest request, UserAgent requiredUserAgent) {
        return BrowserDetect.atLeast(request, requiredUserAgent, -1);
    }

    public static boolean atLeast(HttpServletRequest request, UserAgent requiredUserAgent, int requiredVersion) {
        int realVersion;
        String userAgent = request.getHeader("user-agent");
        switch (requiredUserAgent) {
            case IE: {
                realVersion = BrowserDetect.getMajorVersionAssumingIE(userAgent);
                break;
            }
            case Gecko: {
                realVersion = BrowserDetect.getMajorVersionAssumingGecko(userAgent);
                break;
            }
            case Opera: {
                realVersion = BrowserDetect.getMajorVersionAssumingOpera(userAgent);
                break;
            }
            case AppleWebKit: {
                realVersion = BrowserDetect.getMajorVersionAssumingAppleWebKit(userAgent);
                break;
            }
            case Firefox: {
                realVersion = BrowserDetect.getMajorVersionAssumingFirefox(userAgent);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Detection of " + (Object)((Object)requiredUserAgent) + " is not supported yet.");
            }
        }
        return realVersion >= requiredVersion;
    }

    private static int getMajorVersionAssumingAppleWebKit(String userAgent) {
        int webKitPos = userAgent.indexOf("AppleWebKit");
        if (webKitPos == -1) {
            return -1;
        }
        return BrowserDetect.parseNumberAtStart(userAgent.substring(webKitPos + 12));
    }

    private static int getMajorVersionAssumingFirefox(String userAgent) {
        int firefoxPos = userAgent.indexOf("Firefox");
        if (firefoxPos == -1) {
            return -1;
        }
        return BrowserDetect.parseNumberAtStart(userAgent.substring(firefoxPos + 8));
    }

    private static int getMajorVersionAssumingOpera(String userAgent) {
        int operaPos = userAgent.indexOf("Opera");
        if (operaPos == -1) {
            return -1;
        }
        return BrowserDetect.parseNumberAtStart(userAgent.substring(operaPos + 6));
    }

    private static int getMajorVersionAssumingGecko(String userAgent) {
        int geckoPos = userAgent.indexOf(" Gecko/20");
        if (geckoPos == -1 || userAgent.contains("WebKit/")) {
            return -1;
        }
        return BrowserDetect.parseNumberAtStart(userAgent.substring(geckoPos + 7));
    }

    private static int getMajorVersionAssumingIE(String userAgent) {
        int msiePos = userAgent.indexOf("MSIE ");
        if (msiePos == -1 || userAgent.contains("Opera")) {
            return -1;
        }
        return BrowserDetect.parseNumberAtStart(userAgent.substring(msiePos + 5));
    }

    private static int parseNumberAtStart(String numberString) {
        if (numberString == null || numberString.length() == 0) {
            return -1;
        }
        int endOfNumbers = 0;
        while (Character.isDigit(numberString.charAt(endOfNumbers))) {
            ++endOfNumbers;
        }
        try {
            return Integer.parseInt(numberString.substring(0, endOfNumbers));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String getUserAgentDebugString(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        int version = BrowserDetect.getMajorVersionAssumingIE(userAgent);
        if (version != -1) {
            return "IE/" + version;
        }
        version = BrowserDetect.getMajorVersionAssumingGecko(userAgent);
        if (version != -1) {
            return "Gecko/" + version;
        }
        version = BrowserDetect.getMajorVersionAssumingAppleWebKit(userAgent);
        if (version != -1) {
            return "WebKit/" + version;
        }
        version = BrowserDetect.getMajorVersionAssumingOpera(userAgent);
        if (version != -1) {
            return "Opera/" + version;
        }
        return "Unknown: (" + userAgent + ")";
    }

    @Deprecated
    public static void debugBrowserVersions(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        log.debug((Object)("User-Agent: " + userAgent));
        log.debug((Object)("Version assuming IE: " + BrowserDetect.getMajorVersionAssumingIE(userAgent)));
        log.debug((Object)("Version assuming Gecko: " + BrowserDetect.getMajorVersionAssumingGecko(userAgent)));
        log.debug((Object)("Version assuming Opera: " + BrowserDetect.getMajorVersionAssumingOpera(userAgent)));
        log.debug((Object)("Version assuming WebKit: " + BrowserDetect.getMajorVersionAssumingAppleWebKit(userAgent)));
    }
}

