/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.util.Date;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;

public class LocalDateTimeConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        try {
            long millis = 0L;
            if (value.length() > 0) {
                millis = Long.parseLong(value);
            }
            if (paramType == DateTime.class) {
                return new DateTime(millis);
            }
            if (paramType == LocalDateTime.class) {
                return new LocalDateTime((Object)new Date(millis));
            }
            throw new ConversionException(paramType);
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outboundContext) throws ConversionException {
        long milliSeconds;
        if (data instanceof DateTime) {
            DateTime dateTime = (DateTime)data;
            milliSeconds = dateTime.getMillis();
        } else if (data instanceof LocalDateTime) {
            LocalDateTime date = (LocalDateTime)data;
            milliSeconds = date.toDateTime().toDate().getTime();
        } else {
            throw new ConversionException(data.getClass());
        }
        return new NonNestedOutboundVariable("new Date(" + milliSeconds + ")");
    }
}

