/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1Boolean;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.OIDRegistrar;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.util.OIDManager;
import oracle.security.pki.util.Utils;

public class X509Extension
implements Externalizable,
ASN1Object {
    public static final ASN1ObjectID a = PKIX.ai;
    public static final ASN1ObjectID b = PKIX.aj;
    public static final ASN1ObjectID c = PKIX.ak;
    public static final ASN1ObjectID d = PKIX.al;
    protected boolean e = false;
    private ASN1ObjectID f;
    private boolean g;
    private byte[] h;
    private ASN1Sequence i = null;

    public X509Extension() {
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.f = aSN1ObjectID;
        this.g = bl;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, byte[] byArray) {
        this(aSN1ObjectID, false, byArray);
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID, false, Utils.toBytes(aSN1Object));
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl, byte[] byArray) {
        this.f = aSN1ObjectID;
        this.g = bl;
        this.h = byArray;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl, ASN1Object aSN1Object) {
        this(aSN1ObjectID, bl, Utils.toBytes(aSN1Object));
    }

    public X509Extension(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public static X509Extension a(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream);
        boolean bl = aSN1SequenceInputStream.d() == 1 ? ASN1Boolean.a(aSN1SequenceInputStream) : false;
        byte[] byArray = ASN1OctetString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
        Class<?> clazz = OIDManager.getOIDManager().getMapping(aSN1ObjectID, "extension");
        if (clazz == null) {
            return new X509Extension(aSN1ObjectID, bl, byArray);
        }
        X509Extension x509Extension = null;
        try {
            x509Extension = (X509Extension)clazz.newInstance();
            x509Extension.a(bl);
            x509Extension.a(byArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException.toString());
        }
        return x509Extension;
    }

    public boolean a() {
        return OIDManager.getOIDManager().getMapping(this.b(), "extension") != null;
    }

    public ASN1ObjectID b() {
        return this.f;
    }

    public boolean c() {
        return this.g;
    }

    protected void a(boolean bl) {
        this.g = bl;
        this.f();
    }

    public byte[] d() {
        return this.h;
    }

    protected void a(byte[] byArray) {
        this.h = byArray;
        this.f();
        this.e = false;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.e().output(outputStream);
    }

    private ASN1Sequence e() {
        if (this.i != null) {
            return this.i;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(this.f);
        if (this.g) {
            aSN1Sequence.a(new ASN1Boolean(this.g));
        }
        aSN1Sequence.a(new ASN1OctetString(this.h));
        this.i = aSN1Sequence;
        return this.i;
    }

    private void f() {
        this.i = null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.f();
        this.e = false;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.f = new ASN1ObjectID(aSN1SequenceInputStream);
        this.g = aSN1SequenceInputStream.d() == 1 ? ASN1Boolean.a(aSN1SequenceInputStream) : false;
        this.h = ASN1OctetString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
    }

    @Override
    public int length() {
        return this.e().length();
    }

    public String toString() {
        return "oid = " + this.f + ", critical = " + this.g + ", value = " + Utils.toHexString(this.h);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }

    static {
        OIDRegistrar.a();
    }
}

