/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1Boolean;
import oracle.security.pki.internal.asn1.ASN1Date;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1GenericPrimitive;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Null;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class ASN1Utils {
    public static final int[] a = new int[]{1, 2, 840, 113549};
    public static final int[] b = new int[]{2, 16, 840, 1, 113730};
    public static final int[] c = new int[]{1, 2, 840, 113533, 7};
    public static final int[] d = new int[]{1, 3, 6, 1, 4, 1, 2518};
    public static final int[] e = new int[]{1, 2, 840, 113549, 1};
    public static final int[] f = new int[]{2, 5, 4};
    public static final int[] g = new int[]{1, 3, 14, 3, 2};
    public static final int[] h = new int[]{1, 2, 840, 10040, 4};
    public static final int[] i = new int[]{1, 2, 840, 10046};
    public static final int[] j = new int[]{1, 2, 840, 10045};
    public static final int[] k = new int[]{1, 3, 6, 1, 5, 5, 8};
    public static final int[] l = new int[]{2, 16, 840, 1, 101, 3, 4};
    public static final int[] m = new int[]{1, 3, 6, 1, 4, 1, 3029};

    private ASN1Utils() {
    }

    public static ASN1Object a(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        byte by = Utils.inputByte(pushbackInputStream);
        pushbackInputStream.unread(by);
        if ((by & 0xC0) == 0) {
            switch (by & 0x1F) {
                case 0: {
                    throw new ASN1FormatException("Unexpected end-of-contents octet.");
                }
                case 1: {
                    return new ASN1Boolean(pushbackInputStream);
                }
                case 2: {
                    return new ASN1Integer(pushbackInputStream);
                }
                case 3: {
                    return new ASN1BitString(pushbackInputStream);
                }
                case 4: {
                    return new ASN1OctetString(pushbackInputStream);
                }
                case 5: {
                    return new ASN1Null(pushbackInputStream);
                }
                case 6: {
                    return new ASN1ObjectID(pushbackInputStream);
                }
                case 16: {
                    return new ASN1Sequence(pushbackInputStream);
                }
                case 17: {
                    return new ASN1Set(pushbackInputStream);
                }
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    return new ASN1String(pushbackInputStream);
                }
                case 23: 
                case 24: {
                    return new ASN1Date(pushbackInputStream);
                }
            }
        }
        if ((by & 0x20) == 0) {
            return new ASN1GenericPrimitive(pushbackInputStream);
        }
        return new ASN1GenericConstructed(pushbackInputStream);
    }

    public static ASN1Object a(byte[] byArray) throws IOException {
        return ASN1Utils.a(new ByteArrayInputStream(byArray));
    }

    public static void a(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else {
            int n2 = n >= 0x1000000 ? 4 : (n >= 65536 ? 3 : (n >= 256 ? 2 : 1));
            outputStream.write(0x80 | n2);
            --n2;
            while (n2 >= 0) {
                outputStream.write(n >> 8 * n2 & 0xFF);
                --n2;
            }
        }
    }

    public static void a(int n, OutputStream outputStream) throws IOException {
        for (int i = ASN1Utils.b(n) - 1; i >= 0; --i) {
            int n2 = n >> 7 * i & 0x7F;
            if (i != 0) {
                n2 |= 0x80;
            }
            outputStream.write(n2);
        }
    }

    public static byte[] a(int n) {
        byte[] byArray = new byte[ASN1Utils.b(n)];
        for (int i = byArray.length - 1; i >= 0; --i) {
            int n2 = n >> 7 * i & 0x7F;
            if (i != 0) {
                n2 |= 0x80;
            }
            byArray[byArray.length - 1 - i] = (byte)n2;
        }
        return byArray;
    }

    public static int b(InputStream inputStream) throws IOException {
        byte by;
        int n = 0;
        int n2 = 0;
        do {
            if (n2 > 4 || (n & 0xFF000000) != 0) {
                throw new IOException("Component too large.");
            }
            by = Utils.inputByte(inputStream);
            n <<= 7;
            n |= by & 0x7F;
            ++n2;
        } while ((by & 0x80) != 0);
        return n;
    }

    public static int b(int n) {
        if (n >= 0x10000000) {
            return 5;
        }
        if (n >= 0x200000) {
            return 4;
        }
        if (n >= 16384) {
            return 3;
        }
        if (n >= 128) {
            return 2;
        }
        return 1;
    }

    public static int c(int n) {
        if (n >= 0x1000000) {
            return 4;
        }
        if (n >= 65536) {
            return 3;
        }
        if (n >= 256) {
            return 2;
        }
        return 1;
    }

    public static boolean a(int[] nArray, int[] nArray2) {
        if (nArray.length > nArray2.length) {
            return false;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void a(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(n + n2 + 32);
        outputStream.write(128);
    }

    public static void a(OutputStream outputStream) throws IOException {
        outputStream.write(0);
        outputStream.write(0);
    }

    public static int d(int n) {
        return n & 0x1F;
    }

    public static ASN1Object a(ASN1Object aSN1Object, int n) {
        try {
            InputStream inputStream = Utils.toStream(aSN1Object);
            ASN1Header aSN1Header = new ASN1Header(inputStream);
            if (aSN1Header.c() == 0) {
                return new ASN1GenericPrimitive(aSN1Header.d(inputStream), n);
            }
            ASN1Header aSN1Header2 = new ASN1Header(n, 128, aSN1Header.c(), aSN1Header.d());
            return new ASN1GenericConstructed(new SequenceInputStream(Utils.toStream(aSN1Header2), inputStream));
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException.toString());
        }
    }
}

