/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Interner;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.TreeAnnotator;
import edu.stanford.nlp.parser.lexparser.UnknownWordModel;
import edu.stanford.nlp.process.WordSegmenter;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.Distribution;
import edu.stanford.nlp.stats.EquivalenceClassEval;
import edu.stanford.nlp.stats.GeneralizedCounter;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeToBracketProcessor;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.WordCatEqualityChecker;
import edu.stanford.nlp.trees.WordCatEquivalenceClasser;
import edu.stanford.nlp.trees.international.pennchinese.RadicalMap;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseCharacterBasedLexicon
implements Lexicon {
    protected static PrintWriter pw = null;
    private static double lengthPenalty = 5.0;
    private static int penaltyType = 0;
    private Map<List, Distribution> charDistributions;
    private Set<Symbol> knownChars;
    private Distribution<String> POSDistribution;
    private static boolean useUnknownCharModel = true;
    private static final int CONTEXT_LENGTH = 2;
    protected static final NumberFormat formatter = new DecimalFormat("0.000");
    private static final long serialVersionUID = -5357655683145854069L;

    public static void printStats(Collection<Tree> trees) {
        ClassicCounter<Integer> wordLengthCounter = new ClassicCounter<Integer>();
        ClassicCounter<TaggedWord> wordCounter = new ClassicCounter<TaggedWord>();
        ClassicCounter<Symbol> charCounter = new ClassicCounter<Symbol>();
        int counter = 0;
        for (Tree tree : trees) {
            ++counter;
            ArrayList taggedWords = tree.taggedYield(new ArrayList());
            int size = taggedWords.size();
            for (int i = 0; i < size; ++i) {
                TaggedWord taggedWord = (TaggedWord)taggedWords.get(i);
                String word = taggedWord.word();
                if (word.equals(".$.")) continue;
                wordCounter.incrementCount(taggedWord);
                wordLengthCounter.incrementCount(word.length());
                int length = word.length();
                for (int j = 0; j < length; ++j) {
                    Symbol sym = Symbol.cannonicalSymbol(word.charAt(j));
                    charCounter.incrementCount(sym);
                }
                charCounter.incrementCount(Symbol.END_WORD);
            }
        }
        Set<Symbol> singletonChars = Counters.keysBelow(charCounter, 1.5);
        Set<TaggedWord> singletonWords = Counters.keysBelow(wordCounter, 1.5);
        ClassicCounter<String> singletonWordPOSes = new ClassicCounter<String>();
        for (TaggedWord taggedWord : singletonWords) {
            singletonWordPOSes.incrementCount(taggedWord.tag());
        }
        Distribution singletonWordPOSDist = Distribution.getDistribution(singletonWordPOSes);
        ClassicCounter<Character> singletonCharRads = new ClassicCounter<Character>();
        for (Symbol s : singletonChars) {
            singletonCharRads.incrementCount(Character.valueOf(RadicalMap.getRadical(s.getCh())));
        }
        Distribution singletonCharRadDist = Distribution.getDistribution(singletonCharRads);
        Distribution wordLengthDist = Distribution.getDistribution(wordLengthCounter);
        DecimalFormat percent = new DecimalFormat("##.##%");
        pw.println("There are " + singletonChars.size() + " singleton chars out of " + (int)charCounter.totalCount() + " tokens and " + charCounter.size() + " types found in " + counter + " trees.");
        pw.println("Thus singletonChars comprise " + percent.format((double)singletonChars.size() / charCounter.totalCount()) + " of tokens and " + percent.format((double)singletonChars.size() / (double)charCounter.size()) + " of types.");
        pw.println();
        pw.println("There are " + singletonWords.size() + " singleton words out of " + (int)wordCounter.totalCount() + " tokens and " + wordCounter.size() + " types.");
        pw.println("Thus singletonWords comprise " + percent.format((double)singletonWords.size() / wordCounter.totalCount()) + " of tokens and " + percent.format((double)singletonWords.size() / (double)wordCounter.size()) + " of types.");
        pw.println();
        pw.println("Distribution over singleton word POS:");
        pw.println(singletonWordPOSDist.toString());
        pw.println();
        pw.println("Distribution over singleton char radicals:");
        pw.println(singletonCharRadDist.toString());
        pw.println();
        pw.println("Distribution over word length:");
        pw.println(wordLengthDist);
    }

    @Override
    public void train(Collection<Tree> trees) {
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        Timing.tick("Counting characters...");
        ClassicCounter<Symbol> charCounter = new ClassicCounter<Symbol>();
        for (Tree tree : trees) {
            ArrayList<Label> labels = tree.yield(new ArrayList<Label>());
            int size = labels.size();
            for (int i = 0; i < size; ++i) {
                String word = ((Label)labels.get(i)).value();
                if (word.equals(".$.")) continue;
                int length = word.length();
                for (int j = 0; j < length; ++j) {
                    Symbol sym = Symbol.cannonicalSymbol(word.charAt(j));
                    charCounter.incrementCount(sym);
                }
                charCounter.incrementCount(Symbol.END_WORD);
            }
        }
        Set singletons = Counters.keysBelow(charCounter, 1.5);
        this.knownChars = new HashSet<Symbol>(charCounter.keySet());
        Timing.tick("Counting nGrams...");
        GeneralizedCounter[] POSspecificCharNGrams = new GeneralizedCounter[3];
        for (int i = 0; i <= 2; ++i) {
            POSspecificCharNGrams[i] = new GeneralizedCounter(i + 2);
        }
        ClassicCounter<String> POSCounter = new ClassicCounter<String>();
        List<Object> context = new ArrayList<String>(3);
        for (Tree tree : trees) {
            ArrayList<TaggedWord> words = tree.taggedYield();
            for (TaggedWord taggedWord : words) {
                String word = taggedWord.word();
                String tag = taggedWord.tag();
                tagNumberer.number(tag);
                if (word.equals(".$.")) continue;
                POSCounter.incrementCount(tag);
                int size = word.length();
                block6: for (int i = 0; i <= size; ++i) {
                    Symbol sym;
                    Symbol unknownCharClass = null;
                    context.clear();
                    context.add(tag);
                    if (i < size) {
                        char thisCh = word.charAt(i);
                        sym = Symbol.cannonicalSymbol(thisCh);
                        if (singletons.contains(sym)) {
                            unknownCharClass = this.unknownCharClass(sym);
                            charCounter.incrementCount(unknownCharClass);
                        }
                    } else {
                        sym = Symbol.END_WORD;
                    }
                    POSspecificCharNGrams[0].incrementCount(context, sym);
                    if (unknownCharClass != null) {
                        POSspecificCharNGrams[0].incrementCount(context, unknownCharClass);
                    }
                    for (int j = 1; j <= 2; ++j) {
                        if (i - j < 0) {
                            context.add(Symbol.BEGIN_WORD);
                            POSspecificCharNGrams[j].incrementCount(context, sym);
                            if (unknownCharClass == null) continue block6;
                            POSspecificCharNGrams[j].incrementCount(context, unknownCharClass);
                            continue block6;
                        }
                        Symbol prev = Symbol.cannonicalSymbol(word.charAt(i - j));
                        if (singletons.contains(prev)) {
                            context.add(this.unknownCharClass(prev));
                        } else {
                            context.add(prev);
                        }
                        POSspecificCharNGrams[j].incrementCount(context, sym);
                        if (unknownCharClass == null) continue;
                        POSspecificCharNGrams[j].incrementCount(context, unknownCharClass);
                    }
                }
            }
        }
        this.POSDistribution = Distribution.getDistribution(POSCounter);
        Timing.tick("Creating character prior distribution...");
        this.charDistributions = new HashMap<List, Distribution>();
        int numberOfKeys = charCounter.size() + singletons.size();
        Distribution prior = Distribution.goodTuringSmoothedCounter(charCounter, numberOfKeys);
        this.charDistributions.put(Collections.EMPTY_LIST, prior);
        for (int i = 0; i <= 2; ++i) {
            Set counterEntries = POSspecificCharNGrams[i].lowestLevelCounterEntrySet();
            Timing.tick("Creating " + counterEntries.size() + " character " + (i + 1) + "-gram distributions...");
            for (Map.Entry entry : counterEntries) {
                context = entry.getKey();
                ClassicCounter c = entry.getValue();
                Distribution thisPrior = this.charDistributions.get(context.subList(0, context.size() - 1));
                double priorWeight = (double)thisPrior.getNumberOfKeys() / 200.0;
                Distribution newDist = Distribution.dynamicCounterWithDirichletPrior(c, thisPrior, priorWeight);
                this.charDistributions.put(context, newDist);
            }
        }
    }

    public Distribution<String> getPOSDistribution() {
        return this.POSDistribution;
    }

    public static boolean isForeign(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int num = Character.getNumericValue(s.charAt(i));
            if (num >= 10 && num <= 35) continue;
            return false;
        }
        return true;
    }

    private Symbol unknownCharClass(Symbol ch) {
        if (useUnknownCharModel) {
            return new Symbol(Character.toString(RadicalMap.getRadical(ch.getCh()))).intern();
        }
        return Symbol.UNKNOWN;
    }

    @Override
    public float score(IntTaggedWord iTW, int loc) {
        int i;
        TaggedWord tw = iTW.toTaggedWord();
        String word = tw.word();
        String tag = tw.tag();
        assert (!word.equals(".$."));
        char[] chars = word.toCharArray();
        ArrayList<Object> charList = new ArrayList<Object>(chars.length + 2 + 1);
        charList.add(Symbol.END_WORD);
        for (i = chars.length - 1; i >= 0; --i) {
            Symbol ch = Symbol.cannonicalSymbol(chars[i]);
            if (this.knownChars.contains(ch)) {
                charList.add(ch);
                continue;
            }
            charList.add(this.unknownCharClass(ch));
        }
        for (i = 0; i < 2; ++i) {
            charList.add(Symbol.BEGIN_WORD);
        }
        double score = 0.0;
        int size = charList.size();
        for (int i2 = 0; i2 < size - 2; ++i2) {
            Symbol nextChar = (Symbol)charList.get(i2);
            charList.set(i2, tag);
            double charScore = this.getBackedOffDist(charList.subList(i2, i2 + 2 + 1)).probabilityOf(nextChar);
            score += Math.log(charScore);
        }
        switch (penaltyType) {
            case 0: {
                break;
            }
            case 1: {
                score -= (double)(chars.length * (chars.length + 1)) * (lengthPenalty / 2.0);
                break;
            }
            case 2: {
                score -= (double)(chars.length - 1) * lengthPenalty;
            }
        }
        return (float)score;
    }

    private Distribution<Symbol> getBackedOffDist(List<Serializable> context) {
        for (int i = 3; i >= 0; --i) {
            List<Serializable> l = context.subList(0, i);
            if (!this.charDistributions.containsKey(l)) continue;
            return this.charDistributions.get(l);
        }
        throw new RuntimeException("OOPS... no prior distribution...?");
    }

    /*
     * Enabled aggressive block sorting
     */
    public String sampleFrom(String tag) {
        StringBuilder buf = new StringBuilder();
        ArrayList<Serializable> context = new ArrayList<Serializable>(3);
        context.add((Serializable)((Object)tag));
        for (int i = 0; i < 2; ++i) {
            context.add(Symbol.BEGIN_WORD);
        }
        Distribution<Symbol> d = this.getBackedOffDist(context);
        Symbol gen = d.sampleFrom();
        while (gen != Symbol.END_WORD) {
            buf.append(gen.getCh());
            switch (penaltyType) {
                case 1: {
                    if (!(Math.random() > Math.pow(lengthPenalty, buf.length()))) break;
                    return buf.toString();
                }
                case 2: {
                    if (!(Math.random() > lengthPenalty)) break;
                    return buf.toString();
                }
            }
            for (int i = 1; i < 2; ++i) {
                context.set(i + 1, (Serializable)context.get(i));
            }
            context.set(1, gen);
            d = this.getBackedOffDist(context);
            gen = d.sampleFrom();
        }
        return buf.toString();
    }

    public String sampleFrom() {
        String POS = this.POSDistribution.sampleFrom();
        return this.sampleFrom(POS);
    }

    @Override
    public Iterator<IntTaggedWord> ruleIteratorByWord(int word, int loc, String featureSpec) {
        throw new UnsupportedOperationException("ChineseCharacterBasedLexicon has no rule iterator!");
    }

    @Override
    public int numRules() {
        return 0;
    }

    public void tune(List trees) {
    }

    private Distribution<Integer> getWordLengthDistribution() {
        int samples = 0;
        ClassicCounter<Integer> c = new ClassicCounter<Integer>();
        while (samples++ < 10000) {
            String s = this.sampleFrom();
            c.incrementCount(s.length());
            if (samples % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        Distribution<Integer> genWordLengthDist = Distribution.getDistribution(c);
        return genWordLengthDist;
    }

    public static void main(String[] args) throws IOException {
        HashMap<String, Integer> flagsToNumArgs = new HashMap<String, Integer>();
        flagsToNumArgs.put("-parser", 3);
        flagsToNumArgs.put("-lex", 3);
        flagsToNumArgs.put("-test", 2);
        flagsToNumArgs.put("-out", 1);
        flagsToNumArgs.put("-lengthPenalty", 1);
        flagsToNumArgs.put("-penaltyType", 1);
        flagsToNumArgs.put("-maxLength", 1);
        flagsToNumArgs.put("-stats", 2);
        Map<String, String[]> argMap = StringUtils.argsToMap(args, flagsToNumArgs);
        boolean eval = argMap.containsKey("-eval");
        if (argMap.containsKey("-out")) {
            pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(argMap.get("-out")[0]), "GB18030"), true);
        }
        System.err.println("ChineseCharacterBasedLexicon called with args:");
        ChineseTreebankParserParams ctpp = new ChineseTreebankParserParams();
        for (int i = 0; i < args.length; ++i) {
            ctpp.setOptionFlag(args, i);
            System.err.print(" " + args[i]);
        }
        System.err.println();
        Options op = new Options(ctpp);
        if (argMap.containsKey("-stats")) {
            MemoryTreebank trainTreebank;
            String[] statArgs = argMap.get("-stats");
            MemoryTreebank rawTrainTreebank = op.tlpParams.memoryTreebank();
            NumberRangesFileFilter trainFilt = new NumberRangesFileFilter(statArgs[1], false);
            rawTrainTreebank.loadPath(new File(statArgs[0]), (FileFilter)trainFilt);
            System.err.println("Done reading trees.");
            if (argMap.containsKey("-annotate")) {
                trainTreebank = new MemoryTreebank();
                TreeAnnotator annotator = new TreeAnnotator(ctpp.headFinder(), ctpp);
                for (Tree tree : rawTrainTreebank) {
                    trainTreebank.add(annotator.transformTree(tree));
                }
                System.err.println("Done annotating trees.");
            } else {
                trainTreebank = rawTrainTreebank;
            }
            ChineseCharacterBasedLexicon.printStats(trainTreebank);
            System.exit(0);
        }
        int maxLength = 1000000;
        if (argMap.containsKey("-norm")) {
            Test.lengthNormalization = true;
        }
        if (argMap.containsKey("-maxLength")) {
            maxLength = Integer.parseInt(argMap.get("-maxLength")[0]);
        }
        Test.maxLength = 120;
        boolean combo = argMap.containsKey("-combo");
        if (combo) {
            ctpp.useCharacterBasedLexicon = true;
            Test.maxSpanForTags = 10;
            op.doDep = false;
            op.dcTags = false;
        }
        if (argMap.containsKey("-rad")) {
            useUnknownCharModel = true;
        }
        LexicalizedParser lp = null;
        Lexicon lex = null;
        if (argMap.containsKey("-parser")) {
            String[] parserArgs = argMap.get("-parser");
            if (parserArgs.length > 1) {
                NumberRangesFileFilter trainFilt = new NumberRangesFileFilter(parserArgs[1], false);
                lp = new LexicalizedParser(parserArgs[0], trainFilt, op);
                if (parserArgs.length == 3) {
                    String filename = parserArgs[2];
                    System.err.println("Writing parser in serialized format to file " + filename + " ");
                    System.err.flush();
                    ObjectOutputStream out2 = IOUtils.writeStreamFromString(filename);
                    out2.writeObject(lp.parserData());
                    out2.close();
                    System.err.println("done.");
                }
            } else {
                String parserFile = parserArgs[0];
                lp = new LexicalizedParser(parserFile, op);
            }
            lex = lp.getLexicon();
            op = lp.getOp();
            ctpp = (ChineseTreebankParserParams)op.tlpParams;
        }
        if (argMap.containsKey("-lex")) {
            String[] lexArgs = argMap.get("-lex");
            if (lexArgs.length > 1) {
                MemoryTreebank trainTreebank;
                lex = ctpp.lex(op.lexOptions);
                MemoryTreebank rawTrainTreebank = op.tlpParams.memoryTreebank();
                NumberRangesFileFilter trainFilt = new NumberRangesFileFilter(lexArgs[1], false);
                rawTrainTreebank.loadPath(new File(lexArgs[0]), (FileFilter)trainFilt);
                System.err.println("Done reading trees.");
                if (argMap.containsKey("-annotate")) {
                    trainTreebank = new MemoryTreebank();
                    TreeAnnotator annotator = new TreeAnnotator(ctpp.headFinder(), ctpp);
                    for (Tree tree : rawTrainTreebank) {
                        tree = annotator.transformTree(tree);
                        trainTreebank.add(tree);
                    }
                    System.err.println("Done annotating trees.");
                } else {
                    trainTreebank = rawTrainTreebank;
                }
                lex.train(trainTreebank);
                System.err.println("Done training lexicon.");
                if (lexArgs.length == 3) {
                    String filename = lexArgs.length == 3 ? lexArgs[2] : "parsers/chineseCharLex.ser.gz";
                    System.err.println("Writing lexicon in serialized format to file " + filename + " ");
                    System.err.flush();
                    ObjectOutputStream out3 = IOUtils.writeStreamFromString(filename);
                    out3.writeObject(lex);
                    out3.close();
                    System.err.println("done.");
                }
            } else {
                String lexFile = lexArgs.length == 1 ? lexArgs[0] : "parsers/chineseCharLex.ser.gz";
                System.err.println("Reading Lexicon from file " + lexFile);
                ObjectInputStream in = IOUtils.readStreamFromString(lexFile);
                try {
                    lex = (Lexicon)in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Bad serialized file: " + lexFile);
                }
                in.close();
            }
        }
        if (argMap.containsKey("-lengthPenalty")) {
            lengthPenalty = Double.parseDouble(argMap.get("-lengthPenalty")[0]);
        }
        if (argMap.containsKey("-penaltyType")) {
            penaltyType = Integer.parseInt(argMap.get("-penaltyType")[0]);
        }
        if (argMap.containsKey("-test")) {
            boolean parse;
            boolean segmentWords = ctpp.segmentMarkov || ctpp.segmentMaxMatch;
            boolean bl = parse = lp != null;
            assert (parse || segmentWords);
            WordSegmenter seg = null;
            if (segmentWords) {
                seg = (WordSegmenter)((Object)lex);
            }
            String[] testArgs = argMap.get("-test");
            MemoryTreebank testTreebank = op.tlpParams.memoryTreebank();
            NumberRangesFileFilter testFilt = new NumberRangesFileFilter(testArgs[1], false);
            testTreebank.loadPath(new File(testArgs[0]), (FileFilter)testFilt);
            TreeTransformer subcategoryStripper = op.tlpParams.subcategoryStripper();
            TreeTransformer collinizer = ctpp.collinizer();
            WordCatEquivalenceClasser eqclass = new WordCatEquivalenceClasser();
            WordCatEqualityChecker eqcheck = new WordCatEqualityChecker();
            EquivalenceClassEval basicEval = new EquivalenceClassEval(eqclass, eqcheck, "basic");
            EquivalenceClassEval collinsEval = new EquivalenceClassEval(eqclass, eqcheck, "collinized");
            ArrayList<String> evalTypes = new ArrayList<String>(3);
            boolean goodPOS = false;
            if (segmentWords) {
                evalTypes.add("word");
                if (ctpp.segmentMarkov && !parse) {
                    evalTypes.add("tag");
                    goodPOS = true;
                }
            }
            if (parse) {
                evalTypes.add("tag");
                evalTypes.add("cat");
                if (combo) {
                    evalTypes.add("word");
                    goodPOS = true;
                }
            }
            TreeToBracketProcessor proc = new TreeToBracketProcessor(evalTypes);
            System.err.println("Testing...");
            for (Tree goldTop : testTreebank) {
                Tree tree;
                ArrayList<Label> s;
                Tree gold = goldTop.firstChild();
                ArrayList<Label> goldSentence = gold.yield();
                if (goldSentence.size() > maxLength) {
                    System.err.println("Skipping sentence; too long: " + goldSentence.size());
                    continue;
                }
                System.err.println("Processing sentence; length: " + goldSentence.size());
                if (segmentWords) {
                    StringBuilder goldCharBuf = new StringBuilder();
                    for (StringLabel stringLabel : goldSentence) {
                        goldCharBuf.append(stringLabel.value());
                    }
                    String goldChars = goldCharBuf.toString();
                    s = seg.segmentWords(goldChars);
                } else {
                    s = goldSentence;
                }
                if (parse) {
                    lp.parse(s);
                    tree = lp.getBestParse();
                    if (tree == null) {
                        throw new RuntimeException("PARSER RETURNED NULL!!!");
                    }
                } else {
                    tree = Trees.toFlatTree(s);
                    tree = subcategoryStripper.transformTree(tree);
                }
                if (pw != null) {
                    if (parse) {
                        tree.pennPrint(pw);
                    } else {
                        Iterator<Label> sentIter = s.iterator();
                        while (true) {
                            Word word = (Word)sentIter.next();
                            pw.print(word.word());
                            if (!sentIter.hasNext()) break;
                            pw.print(" ");
                        }
                    }
                    pw.println();
                }
                if (!eval) continue;
                Collection ourBrackets = proc.allBrackets(tree);
                Collection collection = proc.allBrackets(gold);
                if (goodPOS) {
                    ourBrackets.addAll(proc.commonWordTagTypeBrackets(tree, gold));
                    collection.addAll(proc.commonWordTagTypeBrackets(gold, tree));
                }
                basicEval.eval(ourBrackets, collection);
                System.out.println("\nScores:");
                basicEval.displayLast();
                Tree collinsTree = collinizer.transformTree(tree);
                Tree collinsGold = collinizer.transformTree(gold);
                ourBrackets = proc.allBrackets(collinsTree);
                Collection collection2 = proc.allBrackets(collinsGold);
                if (goodPOS) {
                    ourBrackets.addAll(proc.commonWordTagTypeBrackets(collinsTree, collinsGold));
                    collection2.addAll(proc.commonWordTagTypeBrackets(collinsGold, collinsTree));
                }
                collinsEval.eval(ourBrackets, collection2);
                System.out.println("\nCollinized scores:");
                collinsEval.displayLast();
                System.out.println();
            }
            if (eval) {
                basicEval.display();
                System.out.println();
                collinsEval.display();
            }
        }
    }

    @Override
    public void readData(BufferedReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(Writer w) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKnown(int word) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKnown(String word) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnknownWordModel getUnknownWordModel() {
        return null;
    }

    @Override
    public void setUnknownWordModel(UnknownWordModel uwm) {
    }

    private static class Symbol
    implements Serializable {
        private static final int UNKNOWN_TYPE = 0;
        private static final int DIGIT_TYPE = 1;
        private static final int LETTER_TYPE = 2;
        private static final int BEGIN_WORD_TYPE = 3;
        private static final int END_WORD_TYPE = 4;
        private static final int CHAR_TYPE = 5;
        private static final int UNK_CLASS_TYPE = 6;
        private char ch;
        private String unkClass;
        int type;
        public static final Symbol UNKNOWN = new Symbol(0);
        public static final Symbol DIGIT = new Symbol(1);
        public static final Symbol LETTER = new Symbol(2);
        public static final Symbol BEGIN_WORD = new Symbol(3);
        public static final Symbol END_WORD = new Symbol(4);
        public static Interner<Symbol> interner = new Interner();
        private static final long serialVersionUID = 8925032621317022510L;

        public Symbol(char ch) {
            this.type = 5;
            this.ch = ch;
        }

        public Symbol(String unkClass) {
            this.type = 6;
            this.unkClass = unkClass;
        }

        public Symbol(int type) {
            assert (type != 5);
            this.type = type;
        }

        public static Symbol cannonicalSymbol(char ch) {
            if (Character.isDigit(ch)) {
                return DIGIT;
            }
            if (Character.getNumericValue(ch) >= 10 && Character.getNumericValue(ch) <= 35) {
                return LETTER;
            }
            return new Symbol(ch);
        }

        public char getCh() {
            if (this.type == 5) {
                return this.ch;
            }
            return '*';
        }

        public Symbol intern() {
            return interner.intern(this);
        }

        public String toString() {
            if (this.type == 5) {
                return "[u" + this.ch + "]";
            }
            if (this.type == 6) {
                return "UNK:" + this.unkClass;
            }
            return Integer.toString(this.type);
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.type) {
                case 5: {
                    return this.intern();
                }
                case 6: {
                    return this.intern();
                }
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return DIGIT;
                }
                case 2: {
                    return LETTER;
                }
                case 3: {
                    return BEGIN_WORD;
                }
                case 4: {
                    return END_WORD;
                }
            }
            throw new InvalidObjectException("ILLEGAL VALUE IN SERIALIZED SYMBOL");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Symbol)) {
                return false;
            }
            Symbol symbol = (Symbol)o;
            if (this.ch != symbol.ch) {
                return false;
            }
            if (this.type != symbol.type) {
                return false;
            }
            return !(this.unkClass != null ? !this.unkClass.equals(symbol.unkClass) : symbol.unkClass != null);
        }

        public int hashCode() {
            int result = this.ch;
            result = 29 * result + (this.unkClass != null ? this.unkClass.hashCode() : 0);
            result = 29 * result + this.type;
            return result;
        }
    }
}

