/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.SisterAnnotationStats;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAnnotator
implements TreeTransformer {
    private TreeFactory tf;
    private TreebankLangParserParams tlpParams;
    private HeadFinder hf;

    @Override
    public Tree transformTree(Tree t) {
        Tree copy = t.deepCopy(this.tf);
        return this.transformTreeHelper(copy, copy);
    }

    private Tree transformTreeHelper(Tree t, Tree root) {
        String cat2;
        String parentStr;
        Tree parent;
        if (t == null) {
            return null;
        }
        if (t.isLeaf()) {
            return t;
        }
        String cat = t.label().value();
        if (root == null || t.equals(root)) {
            parent = null;
            parentStr = "";
        } else {
            parent = t.parent(root);
            parentStr = parent.label().value();
        }
        String grandParentStr = parent == null || parent.equals(root) ? "" : parent.parent(root).label().value();
        String baseParentStr = this.tlpParams.treebankLanguagePack().basicCategory(parentStr);
        String baseGrandParentStr = this.tlpParams.treebankLanguagePack().basicCategory(grandParentStr);
        if (t.isPreTerminal()) {
            Tree childResult = this.transformTreeHelper(t.children()[0], null);
            String word = childResult.value();
            if (!Train.noTagSplit) {
                if (Train.tagPA) {
                    String test = cat + "^" + baseParentStr;
                    if (!Train.tagSelectiveSplit || Train.splitters.contains(test)) {
                        cat = test;
                    }
                }
                if (Train.markUnaryTags && parent.numChildren() == 1) {
                    cat = cat + "^U";
                }
            }
            Label label = t.label().labelFactory().newLabel(t.label());
            label.setValue(cat);
            if (label instanceof HasCategory) {
                ((HasCategory)((Object)label)).setCategory(cat);
            }
            if (label instanceof HasWord) {
                ((HasWord)((Object)label)).setWord(word);
            }
            if (label instanceof HasTag) {
                ((HasTag)((Object)label)).setTag(cat);
            }
            t.setLabel(label);
            t.setChild(0, childResult);
            if (Train.noTagSplit) {
                return t;
            }
            return this.tlpParams.transformTree(t, root);
        }
        Tree[] kids = t.children();
        for (int childNum = 0; childNum < kids.length; ++childNum) {
            Tree child = kids[childNum];
            Tree childResult = this.transformTreeHelper(child, root);
            t.setChild(childNum, childResult);
        }
        Tree headChild = this.hf.determineHead(t);
        if (headChild == null || headChild.label() == null) {
            throw new RuntimeException("TreeAnnotator: null head found for tree:\n" + t);
        }
        Label headLabel = headChild.label();
        if (!(headLabel instanceof HasWord)) {
            throw new RuntimeException("TreeAnnotator: Head label lacks a Word annotation!");
        }
        if (!(headLabel instanceof HasTag)) {
            throw new RuntimeException("TreeAnnotator: Head label lacks a Tag annotation!");
        }
        String word = ((HasWord)((Object)headLabel)).word();
        String tag = ((HasTag)((Object)headLabel)).tag();
        String baseCat = this.tlpParams.treebankLanguagePack().basicCategory(cat);
        if (Train.sisterAnnotate && !Train.smoothing && baseParentStr.length() > 0) {
            List<String> leftSis = this.listBasicCategories(SisterAnnotationStats.leftSisterLabels(t, parent));
            List<String> rightSis = this.listBasicCategories(SisterAnnotationStats.rightSisterLabels(t, parent));
            ArrayList<String> leftAnn = new ArrayList<String>();
            ArrayList<String> rightAnn = new ArrayList<String>();
            for (String s : leftSis) {
                leftAnn.add(baseCat + "=l=" + this.tlpParams.treebankLanguagePack().basicCategory(s));
            }
            for (String s : rightSis) {
                rightAnn.add(baseCat + "=r=" + this.tlpParams.treebankLanguagePack().basicCategory(s));
            }
            Iterator j = rightAnn.iterator();
            while (j.hasNext()) {
            }
            for (String annCat : Train.sisterSplitters) {
                if (!leftAnn.contains(annCat) && !rightAnn.contains(annCat)) continue;
                cat = cat + annCat.replaceAll("^" + baseCat, "");
                break;
            }
        }
        if (Train.PA && !Train.smoothing && baseParentStr.length() > 0) {
            cat2 = baseCat + "^" + baseParentStr;
            if (!Train.selectiveSplit || Train.splitters.contains(cat2)) {
                cat = cat + "^" + baseParentStr;
            }
        }
        if (Train.gPA && !Train.smoothing && grandParentStr.length() > 0) {
            if (Train.selectiveSplit) {
                cat2 = baseCat + "^" + baseParentStr + "~" + baseGrandParentStr;
                if (cat.contains("^") && Train.splitters.contains(cat2)) {
                    cat = cat + "~" + baseGrandParentStr;
                }
            } else {
                cat = cat + "~" + baseGrandParentStr;
            }
        }
        if (Train.markUnary > 0) {
            if (Train.markUnary == 1 && kids.length == 1 && kids[0].depth() >= 2) {
                cat = cat + "-U";
            } else if (Train.markUnary == 2 && parent != null && parent.numChildren() == 1 && t.depth() >= 2) {
                cat = cat + "-u";
            }
        }
        if (Train.rightRec && TreeAnnotator.rightRec(t, baseCat)) {
            cat = cat + "-R";
        }
        if (Train.leftRec && TreeAnnotator.leftRec(t, baseCat)) {
            cat = cat + "-L";
        }
        if (Train.splitPrePreT && t.isPrePreTerminal()) {
            cat = cat + "-PPT";
        }
        Label label = t.label().labelFactory().newLabel(t.label());
        label.setValue(cat);
        if (label instanceof HasCategory) {
            ((HasCategory)((Object)label)).setCategory(cat);
        }
        if (label instanceof HasWord) {
            ((HasWord)((Object)label)).setWord(word);
        }
        if (label instanceof HasTag) {
            ((HasTag)((Object)label)).setTag(tag);
        }
        t.setLabel(label);
        return this.tlpParams.transformTree(t, root);
    }

    private List<String> listBasicCategories(List<String> l) {
        ArrayList<String> l1 = new ArrayList<String>();
        for (String str : l) {
            l1.add(this.tlpParams.treebankLanguagePack().basicCategory(str));
        }
        return l1;
    }

    private static boolean rightRec(Tree t, String baseCat) {
        if (!baseCat.equals("NP")) {
            return false;
        }
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith(baseCat)) continue;
            return true;
        }
        return false;
    }

    private static boolean leftRec(Tree t, String baseCat) {
        while (!t.isLeaf()) {
            String str = (t = t.firstChild()).label().value();
            if (!str.startsWith(baseCat)) continue;
            return true;
        }
        return false;
    }

    public TreeAnnotator(HeadFinder hf, TreebankLangParserParams tlpp) {
        this.tlpParams = tlpp;
        this.hf = hf;
        this.tf = new LabeledScoredTreeFactory();
    }
}

