/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledScoredTreeNode
extends Tree {
    private static final long serialVersionUID = -8992385140984593817L;
    private Label label = null;
    private double score = Double.NaN;
    private Tree[] daughterTrees = null;
    private static NumberFormat nf = new DecimalFormat("0.000");

    public LabeledScoredTreeNode() {
        this.setChildren(EMPTY_TREE_ARRAY);
    }

    public LabeledScoredTreeNode(Label label) {
        this(label, Double.NaN);
    }

    public LabeledScoredTreeNode(Label label, double score) {
        this();
        this.label = label;
        this.score = score;
    }

    public LabeledScoredTreeNode(Label label, List<Tree> daughterTreesList) {
        this.label = label;
        this.setChildren(daughterTreesList);
    }

    @Override
    public Tree[] children() {
        return this.daughterTrees;
    }

    @Override
    public void setChildren(Tree[] children) {
        this.daughterTrees = children == null ? EMPTY_TREE_ARRAY : children;
    }

    @Override
    public Label label() {
        return this.label;
    }

    @Override
    public void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public TreeFactory treeFactory() {
        LabelFactory lf = this.label() == null ? CoreLabel.factory() : this.label().labelFactory();
        return new LabeledScoredTreeFactory(lf);
    }

    public static TreeFactory factory() {
        return TreeFactoryHolder.tf;
    }

    public static TreeFactory factory(LabelFactory lf) {
        return new LabeledScoredTreeFactory(lf);
    }

    @Override
    public String nodeString() {
        StringBuilder buff = new StringBuilder();
        buff.append(super.nodeString());
        if (!Double.isNaN(this.score)) {
            buff.append(" [").append(nf.format(-this.score)).append("]");
        }
        return buff.toString();
    }

    private static class TreeFactoryHolder {
        static final TreeFactory tf = new LabeledScoredTreeFactory();

        private TreeFactoryHolder() {
        }
    }
}

