/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.ui;

import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TreeJPanel
extends JPanel {
    protected int VERTICAL_ALIGN = 0;
    protected int HORIZONTAL_ALIGN = 0;
    private int maxFontSize = 128;
    private int minFontSize = 2;
    protected static final double sisterSkip = 2.5;
    protected static final double parentSkip = 1.35;
    protected static final double belowLineSkip = 0.075;
    protected static final double aboveLineSkip = 0.075;
    protected Tree tree;

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.repaint();
    }

    protected static String nodeToString(Tree t) {
        return t == null || t.value() == null ? " " : t.value();
    }

    protected static double width(Tree tree, FontMetrics fM) {
        return TreeJPanel.widthResult((Tree)tree, (FontMetrics)fM).width;
    }

    protected static WidthResult widthResult(Tree tree, FontMetrics fM) {
        if (tree == null) {
            return new WidthResult(0.0, 0.0, 0.0, 0.0);
        }
        double local = fM.stringWidth(TreeJPanel.nodeToString(tree));
        if (tree.isLeaf()) {
            return new WidthResult(local, 0.0, local / 2.0, 0.0);
        }
        double sub = 0.0;
        double nodeCenter = 0.0;
        int numKids = tree.numChildren();
        for (int i = 0; i < numKids; ++i) {
            WidthResult subWR = TreeJPanel.widthResult(tree.getChild(i), fM);
            if (i == 0) {
                nodeCenter += (sub + subWR.nodeCenter) / 2.0;
            }
            if (i == numKids - 1) {
                nodeCenter += (sub + subWR.nodeCenter) / 2.0;
            }
            sub += subWR.width;
            if (i >= numKids - 1) continue;
            sub += 2.5 * (double)fM.stringWidth(" ");
        }
        double localLeft = local / 2.0;
        double subLeft = nodeCenter;
        double totalLeft = Math.max(localLeft, subLeft);
        double localRight = local / 2.0;
        double subRight = sub - nodeCenter;
        double totalRight = Math.max(localRight, subRight);
        return new WidthResult(totalLeft + totalRight, totalLeft - localLeft, nodeCenter + totalLeft - subLeft, totalLeft - subLeft);
    }

    protected static double height(Tree tree, FontMetrics fM) {
        if (tree == null) {
            return 0.0;
        }
        double depth = tree.depth();
        return (double)fM.getHeight() * (1.0 + depth * 2.5000000000000004);
    }

    protected FontMetrics pickFont(Graphics2D g2, Tree tree, Dimension space) {
        Font font = g2.getFont();
        String fontName = font.getName();
        int style = font.getStyle();
        for (int size = this.maxFontSize; size > this.minFontSize; --size) {
            font = new Font(fontName, style, size);
            g2.setFont(font);
            FontMetrics fontMetrics = g2.getFontMetrics();
            if (TreeJPanel.height(tree, fontMetrics) > space.getHeight() || TreeJPanel.width(tree, fontMetrics) > space.getWidth()) continue;
            return fontMetrics;
        }
        font = new Font(fontName, style, this.minFontSize);
        g2.setFont(font);
        return g2.getFontMetrics();
    }

    private static double paintTree(Tree t, Point2D start, Graphics2D g2, FontMetrics fM) {
        if (t == null) {
            return 0.0;
        }
        String nodeStr = TreeJPanel.nodeToString(t);
        double nodeWidth = fM.stringWidth(nodeStr);
        double nodeHeight = fM.getHeight();
        double nodeAscent = fM.getAscent();
        WidthResult wr = TreeJPanel.widthResult(t, fM);
        double treeWidth = wr.width;
        double nodeTab = wr.nodeTab;
        double childTab = wr.childTab;
        double nodeCenter = wr.nodeCenter;
        g2.drawString(nodeStr, (float)(nodeTab + start.getX()), (float)(start.getY() + nodeAscent));
        if (t.isLeaf()) {
            return nodeWidth;
        }
        double layerMultiplier = 2.5;
        double layerHeight = nodeHeight * layerMultiplier;
        double childStartX = start.getX() + childTab;
        double childStartY = start.getY() + layerHeight;
        double lineStartX = start.getX() + nodeCenter;
        double lineStartY = start.getY() + nodeHeight * 1.075;
        double lineEndY = lineStartY + nodeHeight * 1.35;
        for (int i = 0; i < t.children().length; ++i) {
            Tree child = t.children()[i];
            double cWidth = TreeJPanel.paintTree(child, new Point2D.Double(childStartX, childStartY), g2, fM);
            wr = TreeJPanel.widthResult(child, fM);
            double lineEndX = childStartX + wr.nodeCenter;
            g2.draw(new Line2D.Double(lineStartX, lineStartY, lineEndX, lineEndY));
            childStartX += cWidth;
            if (i >= t.children().length - 1) continue;
            childStartX += 2.5 * (double)fM.stringWidth(" ");
        }
        return treeWidth;
    }

    protected void superPaint(Graphics g) {
        super.paintComponent(g);
    }

    public void paintComponent(Graphics g) {
        this.superPaint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension space = this.getSize();
        FontMetrics fM = this.pickFont(g2, this.tree, space);
        double width = TreeJPanel.width(this.tree, fM);
        double height = TreeJPanel.height(this.tree, fM);
        double startX = 0.0;
        double startY = 0.0;
        if (this.HORIZONTAL_ALIGN == 0) {
            startX = (space.getWidth() - width) / 2.0;
        }
        if (this.HORIZONTAL_ALIGN == 4) {
            startX = space.getWidth() - width;
        }
        if (this.VERTICAL_ALIGN == 0) {
            startY = (space.getHeight() - height) / 2.0;
        }
        if (this.VERTICAL_ALIGN == 3) {
            startY = space.getHeight() - height;
        }
        TreeJPanel.paintTree(this.tree, new Point2D.Double(startX, startY), g2, fM);
    }

    public TreeJPanel() {
        this(0, 0);
    }

    public TreeJPanel(int hAlign, int vAlign) {
        this.HORIZONTAL_ALIGN = hAlign;
        this.VERTICAL_ALIGN = vAlign;
        this.setPreferredSize(new Dimension(400, 300));
    }

    public void setMinFontSize(int size) {
        this.minFontSize = size;
    }

    public void setMaxFontSize(int size) {
        this.maxFontSize = size;
    }

    public Font pickFont() {
        Font font = this.getFont();
        String fontName = font.getName();
        int style = font.getStyle();
        int size = (this.maxFontSize + this.minFontSize) / 2;
        return new Font(fontName, style, size);
    }

    public Dimension getTreeDimension(Tree tree, Font font) {
        FontMetrics fM = this.getFontMetrics(font);
        return new Dimension((int)TreeJPanel.width(tree, fM), (int)TreeJPanel.height(tree, fM));
    }

    public static void main(String[] args) throws IOException {
        TreeJPanel tjp = new TreeJPanel();
        String ptbTreeString = "(ROOT (S (NP (NNP Interactive_Tregex)) (VP (VBZ works)) (PP (IN for) (PRP me)) (. !))))";
        if (args.length > 0) {
            ptbTreeString = args[0];
        }
        Tree tree = new PennTreeReader(new StringReader(ptbTreeString), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
        tjp.setTree(tree);
        tjp.setBackground(Color.white);
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)tjp, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        frame.setVisible(true);
    }

    public static class WidthResult {
        public final double width;
        public final double nodeTab;
        public final double nodeCenter;
        public final double childTab;

        public WidthResult(double width, double nodeTab, double nodeCenter, double childTab) {
            this.width = width;
            this.nodeTab = nodeTab;
            this.nodeCenter = nodeCenter;
            this.childTab = childTab;
        }
    }
}

