RSpec.describe MetasploitDataModels::AutomaticExploitation::MatchSet, type: :model do
  describe "database" do
    describe "foreign_keys" do
      it { is_expected.to have_db_column(:workspace_id).of_type(:integer) }
      it { is_expected.to have_db_column(:user_id).of_type(:integer) }
    end

    describe "indices" do
      it { is_expected.to have_db_index(:user_id) }
      it { is_expected.to have_db_index(:workspace_id) }
    end
  end

  describe "associations" do
    it { is_expected.to have_many(:matches).class_name('MetasploitDataModels::AutomaticExploitation::Match') }
    it { is_expected.to have_many(:matches).inverse_of(:match_set) }
    it { is_expected.to have_many(:runs).class_name('MetasploitDataModels::AutomaticExploitation::Run') }
    it { is_expected.to have_many(:runs).inverse_of(:match_set) }
    it { is_expected.to belong_to(:user).class_name('Mdm::User') }
    it { is_expected.to belong_to(:user).inverse_of(:automatic_exploitation_match_sets) }
    it { is_expected.to belong_to(:workspace).class_name('Mdm::Workspace') }
    it { is_expected.to belong_to(:workspace).inverse_of(:automatic_exploitation_match_sets) }
  end

  describe "validations" do
    subject(:match_set){ FactoryBot.build(:automatic_exploitation_match_set)}

    describe "missing user" do
      before(:example) do
        match_set.user = nil
      end

      it{ is_expected.to be_invalid }
    end

    describe "missing workspace" do
      before(:example) do
        match_set.workspace = nil
      end

      it{ is_expected.to be_invalid }
    end

  end

end
