class TrackSuccessfulExploits < ActiveRecord::Migration[4.2]


	class ExploitedHost < ApplicationRecord
	end

	class Vuln < ApplicationRecord
	end

	def self.up
		add_column :vulns, :exploited_at, :timestamp

		# Migrate existing exploited_hosts entries

		ExploitedHost.all.select {|x| x.name}.each do |exploited_host|
			next unless(exploited_host.name =~ /^(exploit|auxiliary)\//)
			vulns = Vuln.where(name: exploited_host.name, host_id: exploited_host.host_id)
			next if vulns.empty?
			vulns.each do |vuln|
				vuln.exploited_at = exploited_host.updated_at
				vuln.save
			end
		end
		
	end

	def self.down
		remove_column :vulns, :exploited_at
	end

end
