# A set of {#matches automatic exploitation matches}.
class MetasploitDataModels::AutomaticExploitation::MatchSet < ApplicationRecord
  #
  # Associations
  #

  # Runs of this set of {#matches}.
  has_many :runs,
           class_name: "MetasploitDataModels::AutomaticExploitation::Run",
           inverse_of: :match_set

  # Matches in this set.
  has_many :matches,
           class_name: "MetasploitDataModels::AutomaticExploitation::Match",
           inverse_of: :match_set,
           dependent: :destroy

  # User that created this match set.
  belongs_to :user,
             inverse_of: :automatic_exploitation_match_sets,
             class_name: "Mdm::User"

  # Workspace in which this match set exists.
  belongs_to :workspace,
             inverse_of: :automatic_exploitation_match_sets,
             class_name: "Mdm::Workspace"

  #
  # Validations
  #

  validates :user,
            presence: true

  validates :workspace,
            presence: true


  Metasploit::Concern.run(self)
end
