#
#   Boolean-Based Blind SQL injection support for PostgreSQL
#
class Msf::Exploit::SQLi::PostgreSQLi::BooleanBasedBlind < Msf::Exploit::SQLi::PostgreSQLi::Common
  include Msf::Exploit::SQLi::BooleanBasedBlindMixin

  #
  # This method checks if the target is vulnerable to Blind boolean-based injection by checking that
  # the values returned by the block for some boolean queries are correct.
  # @return [Boolean] Whether the check determined that boolean-based blind SQL injection works
  #
  def test_vulnerable
    out_true = blind_request('1=1')
    out_false = blind_request('1=2')
    out_true && !out_false
  end

end
