# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::ManageEngineAdauditPlus::URIs
  # Required for target_uri and normalize_uri
  include Msf::Exploit::Remote::HttpClient

  # Returns GPOWatcherData endpoint URI on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus GPOWatcherData endpoint URI
  def adaudit_plus_gpo_watcher_data_uri
    normalize_uri(target_uri.path, 'api', 'agent', 'tabs', 'agentGPOWatcherData')
  end

  # Returns the Login URI on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus Login URI
  def adaudit_plus_login_uri
    normalize_uri(target_uri.path, 'j_security_check')
  end

  # Returns the License Details URI on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus License Details URI
  def adaudit_plus_license_details_uri
    normalize_uri(target_uri.path, 'api', 'json', 'tabs', 'showLicenseDetails')
  end

  # Returns the JumpTo.js URI on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus JumpTo.js URI
  def adaudit_plus_jump_to_js_uri
    normalize_uri(target_uri.path, 'adsf', 'js', 'common', 'JumpTo.js')
  end

  # Returns the configuredDomainsList URI on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus configuredDomainsList URI
  def adaudit_plus_configured_domains_uri
    normalize_uri(target_uri.path, 'api', 'json', 'configuredDomainsList')
  end

  # Returns the jsMessage URI on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus jsMessage URI
  def adaudit_api_js_message_uri
    normalize_uri(target_uri.path, 'api', 'json', 'jsMessage')
  end

  # Returns the URI to save alert profiles on the ManageEngine ADAudit Plus target.
  #
  # @return [String] ManageEngine ADAudit Plus URI to save alert profiles
  def adaudit_api_alertprofiles_save_uri
    normalize_uri(target_uri.path, 'api', 'json', 'config', 'alertprofiles', 'save')
  end
end
